---
generated_at: 2025-12-26 23:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：34-倉庫管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **関連ロケーション/オペレーションタイプ自動生成**：CreateWarehouseページの詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/WarehouseResource.php`
- E-02: `plugins/webkul/inventories/src/Models/Warehouse.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (F034行)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-INV-001行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Warehouseモデルを使用 | E-01 (L55), E-02 | ○ |
| C-02 | name属性は必須で最大255文字、一意 | E-01 (L85-92) | ○ |
| C-03 | code属性は必須で最大255文字、一意 | E-01 (L94-100) | ○ |
| C-04 | company_idは必須 | E-01 (L104-109) | ○ |
| C-05 | 会社デフォルトはユーザーのデフォルト会社 | E-01 (L109) | ○ |
| C-06 | 会社は変更不可（disabled） | E-01 (L108) | ○ |
| C-07 | partner_address_idは任意 | E-01 (L110-115) | ○ |
| C-08 | PartnerResourceからフォーム作成可能 | E-01 (L115) | ○ |
| C-09 | reception_stepsはReceptionStep列挙型 | E-01 (L132-136), E-02 (L72) | ○ |
| C-10 | reception_stepsのデフォルトはONE_STEP | E-01 (L135) | ○ |
| C-11 | delivery_stepsはDeliveryStep列挙型 | E-01 (L138-142), E-02 (L73) | ○ |
| C-12 | delivery_stepsのデフォルトはONE_STEP | E-01 (L141) | ○ |
| C-13 | マルチステップは設定で表示制御 | E-01 (L145, 157) | ○ |
| C-14 | 補充元倉庫はCheckboxListで選択 | E-01 (L149-151) | ○ |
| C-15 | 倉庫2件以上で補充設定表示 | E-01 (L153) | ○ |
| C-16 | SoftDeletesトレイト使用 | E-02 (L22) | ○ |
| C-17 | Sortableトレイト使用 | E-02 (L22) | ○ |
| C-18 | 倉庫コード更新時にビューロケーション名同期 | E-02 (L228-232) | ○ |
| C-19 | テーブル名はinventories_warehouses | E-02 (L29) | ○ |
| C-20 | ソフトデリート対応 | E-01 (L221-227) | ○ |
| C-21 | 復元アクションあり | E-01 (L256-262) | ○ |
| C-22 | 完全削除時エラーハンドリング | E-01 (L235-252), (L270-289) | ○ |
| C-23 | パフォーマンス要件（1秒/2秒） | **根拠なし** | △ |
| C-24 | 関連ロケーション/オペレーションタイプ自動生成 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は設計書・要件定義書が見つからない
  - 候補：非機能要件定義書 / システム性能要件書 / SLA文書
- 倉庫作成時の関連エンティティ自動生成ロジック
  - 候補：CreateWarehouse.php / WarehouseObserver.php

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：基本的なCRUD機能はコードで確認済み
- 1（中リスク）：倉庫作成時の自動生成ロジック（ロケーション、オペレーションタイプ）の詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 倉庫名/コードの一意制約が正しく動作するか確認
- [ ] マルチステップ設定が正しく表示/非表示制御されるか確認
- [ ] 倉庫コード変更時のビューロケーション名同期が正しく動作するか確認
- [ ] 完全削除時の外部キー制約エラーハンドリングが正しく動作するか確認
