---
generated_at: 2025-12-26 23:20:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：35-ロケーション管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **子孫更新時間（5秒以内）**：深い階層での実測値確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/LocationResource.php`
- E-02: `plugins/webkul/inventories/src/Models/Location.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (F035行)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-INV-002行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Locationモデルを使用 | E-01 (L56), E-02 | ○ |
| C-02 | name属性は必須で最大255文字 | E-01 (L95-101) | ○ |
| C-03 | type属性は必須でLocationType列挙型 | E-01 (L119-136) | ○ |
| C-04 | typeのデフォルトはINTERNAL | E-01 (L124) | ○ |
| C-05 | 会社デフォルトはユーザーのデフォルト会社 | E-01 (L142) | ○ |
| C-06 | storage_category_idはINTERNALタイプのみ表示 | E-01 (L149) | ○ |
| C-07 | is_scrapはINTERNAL/INVENTORYタイプのみ表示 | E-01 (L155) | ○ |
| C-08 | is_replenishはINTERNALタイプのみ表示 | E-01 (L167) | ○ |
| C-09 | 棚卸設定はINTERNAL/TRANSITタイプのみ表示 | E-01 (L184) | ○ |
| C-10 | タイプ変更時にストレージカテゴリをクリア | E-01 (L131-135) | ○ |
| C-11 | タイプ変更時に補充フラグをクリア | E-01 (L134) | ○ |
| C-12 | テーブル名はinventories_locations | E-02 (L25) | ○ |
| C-13 | SoftDeletesトレイト使用 | E-02 (L18) | ○ |
| C-14 | full_nameの自動生成ロジック | E-02 (L147-156) | ○ |
| C-15 | parent_pathの自動生成ロジック | E-02 (L161-170) | ○ |
| C-16 | VIEWタイプのfull_name = name | E-02 (L149-150) | ○ |
| C-17 | 子孫のfull_name連動更新 | E-02 (L172-185) | ○ |
| C-18 | saveQuietlyで再帰更新 | E-02 (L181) | ○ |
| C-19 | enable_locationsで機能有効化 | E-01 (L68-75) | ○ |
| C-20 | バーコード印刷機能あり | E-01 (L310-323) | ○ |
| C-21 | PDF出力はA4縦向き | E-01 (L318) | ○ |
| C-22 | ファイル名はLocation-Barcode.pdf | E-01 (L322) | ○ |
| C-23 | ソフトデリート対応 | E-01 (L273-279, L280-286) | ○ |
| C-24 | 復元アクションあり | E-01 (L324-330) | ○ |
| C-25 | 完全削除時エラーハンドリング | E-01 (L287-306, L338-357) | ○ |
| C-26 | recordTitleAttributeはfull_name | E-01 (L64) | ○ |
| C-27 | パフォーマンス要件（1秒/2秒） | **根拠なし** | △ |
| C-28 | 子孫更新5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値は設計書・要件定義書が見つからない
  - 候補：非機能要件定義書 / システム性能要件書 / SLA文書
- 深い階層（10階層以上）での子孫更新パフォーマンス
  - 候補：パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：基本的なCRUD機能はコードで確認済み
- 1（中リスク）：深い階層構造での子孫更新パフォーマンス検証推奨
- 1（中リスク）：大量ロケーション一括印刷時のPDF生成パフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] LocationType列挙型の全タイプが正しく動作するか確認
- [ ] タイプ変更時の連動クリア処理が正しく動作するか確認
- [ ] full_name/parent_pathの自動計算が正しく動作するか確認
- [ ] 子孫ロケーションのfull_name連動更新が正しく動作するか確認
- [ ] 完全削除時の外部キー制約エラーハンドリングが正しく動作するか確認
