---
generated_at: 2025-12-26 23:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：36-在庫移動管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **在庫更新ロジック**：OperationResource/ProductResource内の詳細確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/InternalResource.php`
- E-02: `plugins/webkul/inventories/src/Models/Move.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (F036行)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-INV-005行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InternalTransferモデルを使用 | E-01 (L32) | ○ |
| C-02 | enable_locationsで機能有効化 | E-01 (L42-49) | ○ |
| C-03 | OperationResourceのフォームを再利用 | E-01 (L66-68) | ○ |
| C-04 | OperationResourceのテーブルを再利用 | E-01 (L71-73) | ○ |
| C-05 | OperationType.INTERNAL でフィルタ | E-01 (L119-123) | ○ |
| C-06 | ID降順ソート | E-01 (L151-155) | ○ |
| C-07 | DONE状態は削除不可 | E-01 (L79) | ○ |
| C-08 | 削除時エラーハンドリング | E-01 (L80-96) | ○ |
| C-09 | 一括削除時エラーハンドリング | E-01 (L100-117) | ○ |
| C-10 | サブナビゲーションにManageMovesあり | E-01 (L131-138) | ○ |
| C-11 | Moveモデルにstate属性あり | E-02 (L82) | ○ |
| C-12 | Moveモデルにsource_location_id属性あり | E-02 (L58) | ○ |
| C-13 | Moveモデルにdestination_location_id属性あり | E-02 (L59) | ○ |
| C-14 | MoveStateはEnum | E-02 (L82) | ○ |
| C-15 | 機能カテゴリは在庫管理 | E-03 | ○ |
| C-16 | 関連画面はInternalResource | E-04 | ○ |
| C-17 | パフォーマンス要件（1秒/2秒/3秒） | **根拠なし** | △ |
| C-18 | 在庫更新の詳細ロジック | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値
- 移動実行時の在庫更新ロジックの詳細（ProductResource::createMoveなど）

## 5) リスクフラグ（レビュー観点）
- 1（中リスク）：在庫更新ロジックの詳細確認推奨
- 0（低リスク）：基本的なCRUD機能はコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] INTERNAL タイプでのフィルタが正しく動作するか確認
- [ ] DONE状態での編集/削除禁止が正しく動作するか確認
- [ ] 移動実行時の在庫更新が正しく動作するか確認
