---
generated_at: 2025-12-26 23:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：38-ルート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **ルール管理の詳細**：ManageRulesページの詳細確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Configurations/Resources/RouteResource.php`
- E-02: `plugins/webkul/inventories/src/Models/Route.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (F038行)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-INV-007行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Routeモデルを使用 | E-01 (L53), E-02 | ○ |
| C-02 | enable_multi_steps_routesで機能有効化 | E-01 (L65-72) | ○ |
| C-03 | name属性は必須で最大255文字 | E-01 (L90-96) | ○ |
| C-04 | 会社デフォルトはユーザーのデフォルト会社 | E-01 (L113) | ○ |
| C-05 | 削除済み会社も表示（選択不可） | E-01 (L102-109) | ○ |
| C-06 | product_category_selectable設定あり | E-01 (L121-124) | ○ |
| C-07 | product_selectable設定あり | E-01 (L125-128) | ○ |
| C-08 | packaging_selectableはenable_packagings時のみ表示 | E-01 (L129-133) | ○ |
| C-09 | warehouse_selectable設定あり | E-01 (L137-141) | ○ |
| C-10 | 倉庫選択はwarehouse_selectable=true時のみ表示 | E-01 (L142-148) | ○ |
| C-11 | SoftDeletesトレイト使用 | E-02 (L19) | ○ |
| C-12 | Sortableトレイト使用 | E-02 (L19) | ○ |
| C-13 | テーブル名はinventories_routes | E-02 (L26) | ○ |
| C-14 | ソフトデリート対応 | E-01 (L202-208) | ○ |
| C-15 | 復元アクションあり | E-01 (L237-243) | ○ |
| C-16 | 完全削除時エラーハンドリング | E-01 (L216-233) | ○ |
| C-17 | RulesRelationManager使用 | E-01 (L383-388) | ○ |
| C-18 | ManageRulesページあり | E-01 (L379, L397) | ○ |
| C-19 | パフォーマンス要件（1秒/2秒） | **根拠なし** | △ |
| C-20 | ルール管理の詳細ロジック | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値
- ManageRulesページでのルール管理詳細

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：基本的なCRUD機能はコードで確認済み
- 1（中リスク）：ルール管理機能の詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] enable_multi_steps_routes設定による表示制御が正しく動作するか確認
- [ ] 適用対象（商品/カテゴリ/パッケージング/倉庫）の設定が正しく動作するか確認
- [ ] 倉庫選択の表示条件が正しく動作するか確認
- [ ] 完全削除時の外部キー制約エラーハンドリングが正しく動作するか確認
