---
generated_at: 2025-12-26 12:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: 会社管理機能設計書

## 1. 概要

本レポートは「会社管理」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 会社管理Filamentリソース | plugins/webkul/security/src/Filament/Resources/CompanyResource.php | `class CompanyResource extends Resource` | 高 |
| 会社モデル定義 | plugins/webkul/support/src/Models/Company.php | `class Company extends Model implements Sortable` | 高 |
| SoftDelete対応 | 同上 | `use SoftDeletes` | 高 |

### 2.2 ビジネスルールの根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Partner自動作成（creating） | plugins/webkul/support/src/Models/Company.php | `static::creating(function ($company) {...}` | 高 |
| Partner自動更新（saved） | 同上 | `static::saved(function ($company) {...}` | 高 |
| 階層構造（parent-branch） | 同上 | `parent()` および `branches()` リレーション | 高 |
| Sortable対応 | 同上 | `use SortableTrait` および `$sortable` 設定 | 高 |

### 2.3 データ構造の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| fillableカラム定義 | plugins/webkul/support/src/Models/Company.php | `protected $fillable = [...]` | 高 |
| sortカラム | 同上 | fillableに'sort'定義 | 高 |
| parent_idカラム | 同上 | fillableに'parent_id'定義 | 高 |
| partner_idカラム | 同上 | fillableに'partner_id'定義 | 高 |
| currency_idカラム | 同上 | fillableに'currency_id'定義 | 高 |
| country/stateリレーション | 同上 | `country()` および `state()` メソッド | 高 |

### 2.4 リレーションの根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| country関係 | plugins/webkul/support/src/Models/Company.php | `public function country(): BelongsTo` | 高 |
| state関係 | 同上 | `public function state(): BelongsTo` | 高 |
| createdBy関係 | 同上 | `public function createdBy(): BelongsTo` | 高 |
| parent関係 | 同上 | `public function parent(): BelongsTo` | 高 |
| branches関係 | 同上 | `public function branches(): HasMany` | 高 |
| currency関係 | 同上 | `public function currency(): BelongsTo` | 高 |
| partner関係 | 同上 | `public function partner()` | 高 |

### 2.5 トレイト使用の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| HasChatter | plugins/webkul/support/src/Models/Company.php | `use HasChatter` | 高 |
| HasCustomFields | 同上 | `use HasCustomFields` | 高 |
| SoftDeletes | 同上 | `use SoftDeletes` | 高 |
| SortableTrait | 同上 | `use SortableTrait` | 高 |
| HasFactory | 同上 | `use HasFactory` | 高 |

## 3. ソースコード参照

### Company.php（Partner連携部分）
```php
// plugins/webkul/support/src/Models/Company.php
protected static function boot()
{
    parent::boot();

    static::creating(function ($company) {
        if (! $company->partner_id) {
            $partner = Partner::create([
                'creator_id'       => $company->creator_id ?? Auth::id(),
                'sub_type'         => 'company',
                'company_registry' => $company->registration_number,
                'name'             => $company->name,
                'email'            => $company->email,
                // ... その他のフィールド
            ]);

            $company->partner_id = $partner->id;
        }
    });

    static::saved(function ($company) {
        Partner::updateOrCreate(
            ['id' => $company->partner_id],
            [
                'sub_type'         => 'company',
                'name'             => $company->name,
                // ... その他のフィールド
            ]
        );
    });
}
```

### Company.php（階層構造）
```php
// plugins/webkul/support/src/Models/Company.php
public function parent(): BelongsTo
{
    return $this->belongsTo(Company::class, 'parent_id');
}

public function branches(): HasMany
{
    return $this->hasMany(Company::class, 'parent_id');
}

public function isBranch(): bool
{
    return ! is_null($this->parent_id);
}

public function isParent(): bool
{
    return is_null($this->parent_id);
}
```

## 4. 根拠のない記述

| 記述内容 | 理由 | 推奨対応 |
|----------|------|----------|
| 循環参照バリデーション（COMP-003） | 具体的なバリデーション実装コード未確認 | フォームバリデーションの確認が必要 |

## 5. 信頼度評価

- **高信頼度（27件）**: ソースコードから直接確認できる記述
- **低信頼度（1件）**: バリデーション実装の確認が必要

**総合信頼度: 96%**
