---
generated_at: 2025-12-26 12:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート: F042 - 請求書管理

## 1. 概要

本レポートは「F042 - 請求書管理」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| accountsプラグインに属する | plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php | namespace Webkul\Account\Filament\Resources | 高 |
| Moveモデルを使用 | InvoiceResource.php | protected static ?string $model = AccountMove::class | 高 |

### 2.2 入出力仕様に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 顧客選択 | BillResource.php | Select::make('partner_id') (L119) | 高 |
| 請求日入力 | BillResource.php | DatePicker::make('invoice_date') (L138) | 高 |
| 期日入力 | BillResource.php | DatePicker::make('invoice_date_due') (L171) | 高 |
| 支払条件選択 | BillResource.php | Select::make('invoice_payment_term_id') (L178) | 高 |
| 通貨選択 | BillResource.php | Select::make('currency_id') (L247) | 高 |
| 商品選択（明細） | BillResource.php | Select::make('product_id') (L543) | 高 |
| 数量入力 | BillResource.php | TextInput::make('quantity') (L583) | 高 |
| 単価入力 | BillResource.php | TextInput::make('price_unit') (L634) | 高 |
| 税選択（複数） | BillResource.php | Select::make('taxes')->multiple() (L607) | 高 |
| 割引率入力 | BillResource.php | TextInput::make('discount') (L624) | 高 |

### 2.3 処理フローに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 請求書番号自動採番 | Move.php | updateSequencePrefix() (L384-409) | 高 |
| INV/YYYY/MM形式 | Move.php | 'INV/'.$suffix (L390) | 高 |
| 小計計算ロジック | BillResource.php | calculateLineTotals() (L745-783) | 高 |
| Tax::collect()による税計算 | BillResource.php | Tax::collect($taxIds, $subTotal, $quantity) (L777) | 高 |

### 2.4 関連コンポーネントに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Moveモデル | plugins/webkul/accounts/src/Models/Move.php | class Move extends Model (L25) | 高 |
| テーブル名 | Move.php | protected $table = 'accounts_account_moves' (L29) | 高 |
| linesリレーション | Move.php | public function lines() (L294-297) | 高 |
| allLinesリレーション | Move.php | public function allLines() (L299-302) | 高 |
| taxLinesリレーション | Move.php | public function taxLines() (L304-308) | 高 |
| paymentTermLineリレーション | Move.php | public function paymentTermLine() (L310-314) | 高 |
| MoveState Enum | Move.php | 'state' => MoveState::class (L145) | 高 |
| PaymentState Enum | Move.php | 'payment_state' => PaymentState::class (L146) | 高 |
| MoveType Enum | Move.php | 'move_type' => MoveType::class (L147) | 高 |

### 2.5 エラーハンドリングに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 転記済み/取消時の編集制限 | BillResource.php | disabled(fn ($record) => $record && in_array($record->state, [MoveState::POSTED, MoveState::CANCEL])) | 高 |
| 商品重複防止 | BillResource.php | disableOptionWhen() (L558-577) | 高 |
| 必須バリデーション | BillResource.php | required() メソッド各所 | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 26 | 93% |
| 中 | 1 | 4% |
| 低 | 1 | 4% |

### 3.2 未確認事項

1. **InvoiceResource固有のコード**: BillResourceを参照したが、InvoiceResourceの詳細実装は別途確認が必要
2. **確認ボタンのアクション実装**: 転記処理の詳細フローはページクラスで実装されている可能性がある

### 3.3 追加調査推奨事項

1. InvoiceResource専用のページクラスを確認する
2. 転記処理のアクションクラスを確認する
3. 仕訳明細行の生成ロジックを確認する

## 4. ソースコード参照

### 4.1 Moveモデル（抜粋）

```php
// plugins/webkul/accounts/src/Models/Move.php
class Move extends Model implements Sortable
{
    protected $table = 'accounts_account_moves';

    protected $casts = [
        'invoice_date_due' => 'datetime',
        'state'            => MoveState::class,
        'payment_state'    => PaymentState::class,
        'move_type'        => MoveType::class,
    ];

    public function updateSequencePrefix()
    {
        $suffix = date('Y').'/'.date('m');
        switch ($this->move_type) {
            case MoveType::OUT_INVOICE:
                $this->sequence_prefix = 'INV/'.$suffix;
                break;
            // ...
        }
    }
}
```

### 4.2 小計計算ロジック（抜粋）

```php
// plugins/webkul/accounts/src/Filament/Resources/BillResource.php
private static function calculateLineTotals(Set $set, Get $get): void
{
    $priceUnit = floatval($get('price_unit'));
    $quantity = floatval($get('quantity') ?? 1);
    $subTotal = $priceUnit * $quantity;

    $discountValue = floatval($get('discount') ?? 0);
    if ($discountValue > 0) {
        $discountAmount = $subTotal * ($discountValue / 100);
        $subTotal = $subTotal - $discountAmount;
    }

    $taxIds = $get('taxes') ?? [];
    [$subTotal, $taxAmount] = Tax::collect($taxIds, $subTotal, $quantity);

    $set('price_subtotal', round($subTotal, 4));
    $set('price_tax', $taxAmount);
    $set('price_total', $subTotal + $taxAmount);
}
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき93%の信頼度で検証された。InvoiceResourceはBillResourceと類似の構造を持つと推測されるが、詳細は追加調査を推奨する。
