---
generated_at: 2025-12-26 12:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート: F043 - 返金管理

## 1. 概要

本レポートは「F043 - 返金管理」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| accountsプラグインに属する | plugins/webkul/accounts/src/Filament/Resources/RefundResource.php | namespace Webkul\Account\Filament\Resources | 高 |
| Moveモデルを使用 | RefundResource.php継承元 | AccountMove::class | 高 |
| move_type = 'out_refund' | plugins/webkul/accounts/src/Models/Move.php | MoveType::OUT_REFUND (L393) | 高 |

### 2.2 入出力仕様に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 請求書と同様のフォーム構造 | RefundResource.php | InvoiceResource/BillResourceを継承 | 高 |
| 逆仕訳参照 | Move.php | reversed_entry_id フィールド (L46) | 高 |
| reversedEntryリレーション | Move.php | public function reversedEntry() (L214-217) | 高 |

### 2.3 処理フローに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 返金番号自動採番 | Move.php | updateSequencePrefix() (L384-409) | 高 |
| RINV/YYYY/MM形式 | Move.php | 'RINV/'.$suffix (L393) | 高 |
| 請求書からの返金作成 | RefundResource.php/アクション定義 | 推測（実装詳細未確認） | 中 |

### 2.4 関連コンポーネントに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Moveモデル | plugins/webkul/accounts/src/Models/Move.php | class Move extends Model (L25) | 高 |
| reversedEntryリレーション | Move.php | belongsTo(self::class, 'reversed_entry_id') (L216) | 高 |
| MoveType::OUT_REFUND | Move.php | case MoveType::OUT_REFUND (L393) | 高 |
| MoveType::IN_REFUND | Move.php | MoveType::IN_REFUND 参照 (L269, L344) | 高 |

### 2.5 エラーハンドリングに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 編集制限 | BillResource.php | disabled条件でMoveState::POSTED, CANCEL判定 | 高 |
| バリデーション | Filament標準機能 | required() 等のメソッド | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 14 | 78% |
| 中 | 2 | 11% |
| 低 | 2 | 11% |

### 3.2 未確認事項

1. **RefundResource固有の実装**: RefundResourceの詳細実装は確認が必要
2. **請求書からの返金作成アクション**: 具体的なアクション実装は未確認

### 3.3 追加調査推奨事項

1. RefundResourceのページクラスを確認する
2. 請求書から返金を作成するアクションの実装を確認する

## 4. ソースコード参照

### 4.1 Moveモデル - 返金番号採番

```php
// plugins/webkul/accounts/src/Models/Move.php
public function updateSequencePrefix()
{
    $suffix = date('Y').'/'.date('m');
    switch ($this->move_type) {
        // ...
        case MoveType::OUT_REFUND:
            $this->sequence_prefix = 'RINV/'.$suffix;
            break;
        case MoveType::IN_REFUND:
            $this->sequence_prefix = 'RBILL/'.$suffix;
            break;
        // ...
    }
}
```

### 4.2 逆仕訳参照リレーション

```php
// plugins/webkul/accounts/src/Models/Move.php
public function reversedEntry()
{
    return $this->belongsTo(self::class, 'reversed_entry_id');
}
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき89%の信頼度で検証された。返金機能は請求書機能と同様の構造を持ち、Moveモデルを共有している。詳細なアクション実装については追加調査を推奨する。
