---
generated_at: 2025-12-26 12:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート: F044 - 仕訳帳管理

## 1. 概要

本レポートは「F044 - 仕訳帳管理」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| accountsプラグインに属する | plugins/webkul/accounts/src/Filament/Resources/JournalResource.php | namespace Webkul\Account\Filament\Resources | 高 |
| Journalモデルを使用 | plugins/webkul/accounts/src/Models/Journal.php | class Journal extends Model (L17) | 高 |

### 2.2 入出力仕様に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| テーブル名 | Journal.php | protected $table = 'accounts_journals' (L21) | 高 |
| name フィールド | Journal.php | fillable: 'name' (L40) | 高 |
| code フィールド | Journal.php | fillable: 'code' (L35) | 高 |
| type フィールド | Journal.php | fillable: 'type' (L36) | 高 |
| company_id | Journal.php | fillable: 'company_id' (L27) | 高 |
| currency_id | Journal.php | fillable: 'currency_id' (L26) | 高 |
| default_account_id | Journal.php | fillable: 'default_account_id' (L24) | 高 |
| suspense_account_id | Journal.php | fillable: 'suspense_account_id' (L25) | 高 |
| profit_account_id | Journal.php | fillable: 'profit_account_id' (L28) | 高 |
| loss_account_id | Journal.php | fillable: 'loss_account_id' (L29) | 高 |
| bank_account_id | Journal.php | fillable: 'bank_account_id' (L30) | 高 |
| color | Journal.php | fillable: 'color' (L32) | 高 |
| show_on_dashboard | Journal.php | fillable: 'show_on_dashboard' (L46) | 高 |
| auto_check_on_post | Journal.php | fillable: 'auto_check_on_post' (L42) | 高 |

### 2.3 処理フローに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 支払方法ライン自動生成 | Journal.php | computeInboundPaymentMethodLines() (L122-143) | 高 |
| bank/cash/credit判定 | Journal.php | in_array($this->type, ['bank', 'cash', 'credit']) (L124) | 高 |
| 既存ライン削除 | Journal.php | $this->inboundPaymentMethodLines()->delete() (L131) | 高 |
| アクティブ支払方法取得 | Journal.php | getDefaultInboundPaymentMethods() (L145-150) | 高 |

### 2.4 関連コンポーネントに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Sortable実装 | Journal.php | class Journal extends Model implements Sortable (L17) | 高 |
| companyリレーション | Journal.php | public function company() (L59-62) | 高 |
| currencyリレーション | Journal.php | public function currency() (L69-72) | 高 |
| defaultAccountリレーション | Journal.php | public function defaultAccount() (L74-77) | 高 |
| suspenseAccountリレーション | Journal.php | public function suspenseAccount() (L89-92) | 高 |
| profitAccountリレーション | Journal.php | public function profitAccount() (L84-87) | 高 |
| lossAccountリレーション | Journal.php | public function lossAccount() (L79-82) | 高 |
| bankAccountリレーション | Journal.php | public function bankAccount() (L54-57) | 高 |
| allowedAccountsリレーション | Journal.php | public function allowedAccounts() (L94-97) | 高 |
| inboundPaymentMethodLinesリレーション | Journal.php | public function inboundPaymentMethodLines() (L112-115) | 高 |
| outboundPaymentMethodLinesリレーション | Journal.php | public function outboundPaymentMethodLines() (L117-120) | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 21 | 95% |
| 中 | 1 | 5% |
| 低 | 0 | 0% |

### 3.2 未確認事項

1. **JournalType Enum定義**: Enumファイルの詳細は未確認だが、コードから推測可能

### 3.3 追加調査推奨事項

1. JournalType Enumの詳細定義を確認する
2. JournalResourceのフォーム定義を確認する

## 4. ソースコード参照

### 4.1 Journalモデル

```php
// plugins/webkul/accounts/src/Models/Journal.php
class Journal extends Model implements Sortable
{
    use HasFactory, SortableTrait;

    protected $table = 'accounts_journals';

    protected $fillable = [
        'default_account_id',
        'suspense_account_id',
        'sort',
        'currency_id',
        'company_id',
        'profit_account_id',
        'loss_account_id',
        'bank_account_id',
        'creator_id',
        'color',
        'access_token',
        'code',
        'type',
        'invoice_reference_type',
        'invoice_reference_model',
        'bank_statements_source',
        'name',
        'order_override_regex',
        'auto_check_on_post',
        'restrict_mode_hash_table',
        'refund_order',
        'payment_order',
        'show_on_dashboard',
    ];
}
```

### 4.2 支払方法ライン自動生成

```php
// plugins/webkul/accounts/src/Models/Journal.php
public function computeInboundPaymentMethodLines(): void
{
    if (! in_array($this->type, ['bank', 'cash', 'credit'])) {
        $this->inboundPaymentMethodLines()->delete();
        return;
    }

    DB::transaction(function () {
        $this->inboundPaymentMethodLines()->delete();
        $defaultMethods = $this->getDefaultInboundPaymentMethods();

        foreach ($defaultMethods as $method) {
            $this->inboundPaymentMethodLines()->create([
                'name'              => $method->name,
                'payment_method_id' => $method->id,
                'type'              => 'inbound',
            ]);
        }
    });
}
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき95%の信頼度で検証された。仕訳帳管理機能の実装は明確に確認でき、モデル定義とリレーションは設計書の記載と一致している。
