---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: F045 - 税グループ管理

## 1. 概要

本レポートは「F045 - 税グループ管理」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| accountsプラグインに属する | plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource.php | namespace Webkul\Account\Filament\Resources (L3) | 高 |
| TaxGroupモデルを使用 | TaxGroupResource.php | protected static ?string $model = TaxGroup::class (L31) | 高 |

### 2.2 入出力仕様に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| テーブル名 | plugins/webkul/accounts/src/Models/TaxGroup.php | protected $table = 'accounts_tax_groups' (L18) | 高 |
| name フィールド | TaxGroupResource.php | TextInput::make('name')->required() (L53-56) | 高 |
| company_id | TaxGroupResource.php | Select::make('company_id')->relationship('company', 'name') (L43-47) | 高 |
| country_id | TaxGroupResource.php | Select::make('country_id')->relationship('country', 'name') (L48-52) | 高 |
| preceding_subtotal | TaxGroupResource.php | TextInput::make('preceding_subtotal') (L57-59) | 高 |

### 2.3 一覧表示に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| company.name列 | TaxGroupResource.php | TextColumn::make('company.name') (L68-70) | 高 |
| country.name列 | TaxGroupResource.php | TextColumn::make('country.name') (L71-73) | 高 |
| createdBy.name列 | TaxGroupResource.php | TextColumn::make('createdBy.name') (L74-76) | 高 |
| name列 | TaxGroupResource.php | TextColumn::make('name') (L77-79) | 高 |
| preceding_subtotal列 | TaxGroupResource.php | TextColumn::make('preceding_subtotal') (L80-82) | 高 |

### 2.4 関連コンポーネントに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Sortable実装 | TaxGroup.php | class TaxGroup extends Model implements Sortable (L13) | 高 |
| companyリレーション | TaxGroup.php | public function company() (L33-36) | 高 |
| countryリレーション | TaxGroup.php | public function country() (L38-41) | 高 |
| createdByリレーション | TaxGroup.php | public function createdBy() (L43-46) | 高 |

### 2.5 エラーハンドリングに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 削除時のQueryExceptionキャッチ | TaxGroupResource.php | catch (QueryException $e) (L121-126) | 高 |
| エラー通知 | TaxGroupResource.php | Notification::make()->danger() (L122-126) | 高 |
| 一括削除のエラーハンドリング | TaxGroupResource.php | catch (QueryException $e) (L143-150) | 高 |

### 2.6 ページ定義に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ListTaxGroups | TaxGroupResource.php | 'index' => ListTaxGroups::route('/') (L193) | 高 |
| CreateTaxGroup | TaxGroupResource.php | 'create' => CreateTaxGroup::route('/create') (L194) | 高 |
| ViewTaxGroup | TaxGroupResource.php | 'view' => ViewTaxGroup::route('/{record}') (L195) | 高 |
| EditTaxGroup | TaxGroupResource.php | 'edit' => EditTaxGroup::route('/{record}/edit') (L196) | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 18 | 100% |
| 中 | 0 | 0% |
| 低 | 0 | 0% |

### 3.2 未確認事項

なし

## 4. ソースコード参照

### 4.1 TaxGroupモデル

```php
// plugins/webkul/accounts/src/Models/TaxGroup.php
class TaxGroup extends Model implements Sortable
{
    use HasFactory, SortableTrait;

    protected $table = 'accounts_tax_groups';

    protected $fillable = [
        'sort',
        'company_id',
        'country_id',
        'creator_id',
        'name',
        'preceding_subtotal',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
}
```

### 4.2 削除時エラーハンドリング

```php
// plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource.php
DeleteAction::make()
    ->action(function (TaxGroup $record) {
        try {
            $record->delete();
        } catch (QueryException $e) {
            Notification::make()
                ->danger()
                ->title(__('accounts::filament/resources/tax-group.table.actions.delete.notification.error.title'))
                ->body(__('accounts::filament/resources/tax-group.table.actions.delete.notification.error.body'))
                ->send();
        }
    })
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき100%の信頼度で検証された。税グループ管理機能の実装は設計書の記載と完全に一致している。
