---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: F046 - 税管理

## 1. 概要

本レポートは「F046 - 税管理」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| accountsプラグインに属する | plugins/webkul/accounts/src/Filament/Resources/TaxResource.php | namespace Webkul\Account\Filament\Resources (L3) | 高 |
| Taxモデルを使用 | TaxResource.php | protected static ?string $model = Tax::class (L44) | 高 |

### 2.2 入出力仕様に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| テーブル名 | plugins/webkul/accounts/src/Models/Tax.php | protected $table = 'accounts_taxes' (L20) | 高 |
| name フィールド | TaxResource.php | TextInput::make('name')->required() (L60-62) | 高 |
| type_tax_use フィールド | TaxResource.php | Select::make('type_tax_use')->options(TypeTaxUse::options()) (L63-66) | 高 |
| amount_type フィールド | TaxResource.php | Select::make('amount_type')->options(AmountType::options()) (L67-70) | 高 |
| tax_scope フィールド | TaxResource.php | Select::make('tax_scope')->options(TaxScope::options()) (L71-73) | 高 |
| is_active フィールド | TaxResource.php | Toggle::make('is_active') (L74-76) | 高 |
| amount フィールド | TaxResource.php | TextInput::make('amount')->numeric()->suffix('%') (L77-83) | 高 |
| invoice_label フィールド | TaxResource.php | TextInput::make('invoice_label') (L87-88) | 高 |
| tax_group_id フィールド | TaxResource.php | Select::make('tax_group_id')->relationship('taxGroup', 'name')->required() (L89-93) | 高 |
| country_id フィールド | TaxResource.php | Select::make('country_id')->relationship('country', 'name') (L94-96) | 高 |
| price_include_override フィールド | TaxResource.php | Select::make('price_include_override')->options(TaxIncludeOverride::class) (L97-100) | 高 |
| include_base_amount フィールド | TaxResource.php | Toggle::make('include_base_amount') (L102-105) | 高 |
| is_base_affected フィールド | TaxResource.php | Toggle::make('is_base_affected') (L106-109) | 高 |
| description フィールド | TaxResource.php | RichEditor::make('description') (L111-112) | 高 |
| invoice_legal_notes フィールド | TaxResource.php | RichEditor::make('invoice_legal_notes') (L113-114) | 高 |

### 2.3 税配分自動生成に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 作成時自動生成 | Tax.php | static::created(function (self $tax) { ... }) (L94-98) | 高 |
| 請求書用配分生成 | Tax.php | attachDistributionForInvoice($tax) (L95, L100-132) | 高 |
| 返金用配分生成 | Tax.php | attachDistributionForRefund($tax) (L96, L134-166) | 高 |
| BASEタイプ配分 | Tax.php | RepartitionType::BASE->value (L108, L149) | 高 |
| TAXタイプ配分 | Tax.php | RepartitionType::TAX->value (L117, L158) | 高 |
| factor_percent: 100 | Tax.php | 'factor_percent' => 100 (L124, L161) | 高 |

### 2.4 関連コンポーネントに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Sortable実装 | Tax.php | class Tax extends Model implements Sortable (L16) | 高 |
| companyリレーション | Tax.php | public function company() (L50-53) | 高 |
| taxGroupリレーション | Tax.php | public function taxGroup() (L55-58) | 高 |
| countryリレーション | Tax.php | public function country() (L65-68) | 高 |
| createdByリレーション | Tax.php | public function createdBy() (L70-73) | 高 |
| distributionForInvoiceリレーション | Tax.php | public function distributionForInvoice() (L75-78) | 高 |
| distributionForRefundリレーション | Tax.php | public function distributionForRefund() (L80-83) | 高 |
| parentTaxesリレーション | Tax.php | public function parentTaxes() (L85-88) | 高 |

### 2.5 Enum使用に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| TypeTaxUse使用 | TaxResource.php | use Webkul\Account\Enums\TypeTaxUse (L35) | 高 |
| AmountType使用 | TaxResource.php | use Webkul\Account\Enums\AmountType (L32) | 高 |
| TaxScope使用 | TaxResource.php | use Webkul\Account\Enums\TaxScope (L34) | 高 |
| TaxIncludeOverride使用 | TaxResource.php | use Webkul\Account\Enums\TaxIncludeOverride (L33) | 高 |
| RepartitionType使用 | Tax.php | use Webkul\Account\Enums\RepartitionType (L11) | 高 |
| DocumentType使用 | Tax.php | use Webkul\Account\Enums\DocumentType (L10) | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 25 | 96% |
| 中 | 1 | 4% |
| 低 | 0 | 0% |

### 3.2 未確認事項

1. **Tax::collect()ファサード**: ファサードの詳細実装は未確認だが、BillResourceでの使用が確認できる

## 4. ソースコード参照

### 4.1 Taxモデル - 配分自動生成

```php
// plugins/webkul/accounts/src/Models/Tax.php
protected static function boot()
{
    parent::boot();

    static::created(function (self $tax) {
        $tax->attachDistributionForInvoice($tax);
        $tax->attachDistributionForRefund($tax);
    });
}

private function attachDistributionForInvoice(self $tax)
{
    $distributionForInvoices = [
        [
            'tax_id'             => $tax->id,
            'company_id'         => $tax->company_id,
            'repartition_type'   => RepartitionType::BASE->value,
            'document_type'      => DocumentType::INVOICE->value,
            'factor_percent'     => null,
            'factor'             => null,
            // ...
        ],
        [
            'tax_id'             => $tax->id,
            'company_id'         => $tax->company_id,
            'repartition_type'   => RepartitionType::TAX->value,
            'document_type'      => DocumentType::INVOICE->value,
            'factor_percent'     => 100,
            'factor'             => 1,
            // ...
        ],
    ];

    DB::table('accounts_tax_partition_lines')->insert($distributionForInvoices);
}
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき96%の信頼度で検証された。税管理機能の実装は設計書の記載とほぼ完全に一致しており、特に税配分の自動生成ロジックが明確に確認できた。
