---
generated_at: 2025-12-26 12:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート: F047 - 財政ポジション管理

## 1. 概要

本レポートは「F047 - 財政ポジション管理」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| accountsプラグインに属する | plugins/webkul/accounts/src/Filament/Resources/FiscalPositionResource.php | namespace Webkul\Account\Filament\Resources (L3) | 高 |
| FiscalPositionモデルを使用 | FiscalPositionResource.php | protected static ?string $model = FiscalPosition::class (L37) | 高 |

### 2.2 入出力仕様に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| テーブル名 | plugins/webkul/accounts/src/Models/FiscalPosition.php | protected $table = 'accounts_fiscal_positions' (L17) | 高 |
| name フィールド | FiscalPositionResource.php | TextInput::make('name')->required() (L51-54) | 高 |
| foreign_vat フィールド | FiscalPositionResource.php | TextInput::make('foreign_vat')->required() (L55-58) | 高 |
| country_id フィールド | FiscalPositionResource.php | Select::make('country_id')->relationship('country', 'name') (L59-63) | 高 |
| country_group_id フィールド | FiscalPositionResource.php | Select::make('country_group_id')->relationship('countryGroup', 'name') (L64-68) | 高 |
| zip_from フィールド | FiscalPositionResource.php | TextInput::make('zip_from')->required() (L69-71) | 高 |
| zip_to フィールド | FiscalPositionResource.php | TextInput::make('zip_to')->required() (L72-74) | 高 |
| auto_reply フィールド | FiscalPositionResource.php | Toggle::make('auto_reply') (L75-77) | 高 |
| notes フィールド | FiscalPositionResource.php | RichEditor::make('notes') (L79-80) | 高 |

### 2.3 関連コンポーネントに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Sortable実装 | FiscalPosition.php | class FiscalPosition extends Model implements Sortable (L13) | 高 |
| companyリレーション | FiscalPosition.php | public function company() (L39-42) | 高 |
| countryリレーション | FiscalPosition.php | public function country() (L44-47) | 高 |
| countryGroupリレーション | FiscalPosition.php | public function countryGroup() (L49-52) | 高 |
| createdByリレーション | FiscalPosition.php | public function createdBy() (L54-57) | 高 |
| fiscalPositionTaxesリレーション | FiscalPosition.php | public function fiscalPositionTaxes() (L59-62) | 高 |

### 2.4 ページ定義に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ListFiscalPositions | FiscalPositionResource.php | 'index' => ListFiscalPositions::route('/') (L221) | 高 |
| CreateFiscalPosition | FiscalPositionResource.php | 'create' => CreateFiscalPosition::route('/create') (L222) | 高 |
| ViewFiscalPosition | FiscalPositionResource.php | 'view' => ViewFiscalPosition::route('/{record}') (L223) | 高 |
| EditFiscalPosition | FiscalPositionResource.php | 'edit' => EditFiscalPosition::route('/{record}/edit') (L224) | 高 |
| ManageFiscalPositionTax | FiscalPositionResource.php | 'fiscal-position-tax' => ManageFiscalPositionTax::route('/{record}/fiscal-position-tax') (L225) | 高 |

### 2.5 RelationManager関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| FiscalPositionTaxRelationManager | FiscalPositionResource.php | use FiscalPositionTaxRelationManager (L32) | 高 |
| RelationGroup使用 | FiscalPositionResource.php | RelationGroup::make('distribution_for_invoice', [...]) (L211-214) | 高 |

### 2.6 サブナビゲーション関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| getRecordSubNavigation | FiscalPositionResource.php | public static function getRecordSubNavigation(Page $page) (L199-206) | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 19 | 95% |
| 中 | 1 | 5% |
| 低 | 0 | 0% |

### 3.2 未確認事項

1. **自動検出機能の詳細ロジック**: auto_replyフラグを使用した自動検出の具体的な実装は、請求書作成時のロジック内にあると推測される

## 4. ソースコード参照

### 4.1 FiscalPositionモデル

```php
// plugins/webkul/accounts/src/Models/FiscalPosition.php
class FiscalPosition extends Model implements Sortable
{
    use HasFactory, SortableTrait;

    protected $table = 'accounts_fiscal_positions';

    protected $fillable = [
        'sort',
        'company_id',
        'country_id',
        'country_group_id',
        'creator_id',
        'zip_from',
        'zip_to',
        'foreign_vat',
        'name',
        'notes',
        'auto_reply',
        'vat_required',
    ];

    public function fiscalPositionTaxes()
    {
        return $this->hasMany(FiscalPositionTax::class, 'fiscal_position_id');
    }
}
```

### 4.2 ページ定義

```php
// plugins/webkul/accounts/src/Filament/Resources/FiscalPositionResource.php
public static function getPages(): array
{
    return [
        'index'               => ListFiscalPositions::route('/'),
        'create'              => CreateFiscalPosition::route('/create'),
        'view'                => ViewFiscalPosition::route('/{record}'),
        'edit'                => EditFiscalPosition::route('/{record}/edit'),
        'fiscal-position-tax' => ManageFiscalPositionTax::route('/{record}/fiscal-position-tax'),
    ];
}
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき95%の信頼度で検証された。財政ポジション管理機能の実装は設計書の記載とほぼ完全に一致しており、税マッピング機能も含めて確認できた。
