---
generated_at: 2025-12-26 12:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: F048 - 銀行口座管理

## 1. 概要

本レポートは「F048 - 銀行口座管理」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| accountsプラグインに属する | plugins/webkul/accounts/src/Filament/Resources/BankAccountResource.php | namespace Webkul\Account\Filament\Resources (L3) | 高 |
| partnersを継承 | BankAccountResource.php (accounts) | class BankAccountResource extends BaseBankAccountResource (L10) | 高 |
| BaseBankAccountResource使用 | BankAccountResource.php (accounts) | use Webkul\Partner\Filament\Resources\BankAccountResource as BaseBankAccountResource (L8) | 高 |

### 2.2 入出力仕様に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| テーブル名 | plugins/webkul/partners/src/Models/BankAccount.php | protected $table = 'partners_bank_accounts' (L22) | 高 |
| account_number フィールド | BankAccountResource.php (partners) | TextInput::make('account_number')->required()->unique() (L50-53) | 高 |
| bank_id フィールド | BankAccountResource.php (partners) | Select::make('bank_id')->relationship('bank', 'name')->required() (L58-74) | 高 |
| partner_id フィールド | BankAccountResource.php (partners) | Select::make('partner_id')->relationship('partner', 'name')->required() (L75-83) | 高 |

### 2.3 カスタマイズに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| フォームコンポーネント削除 | BankAccountResource.php (accounts) | $components = collect($schema->getComponents())->forget(1)->all() (L18) | 高 |
| can_send_money列削除 | BankAccountResource.php (accounts) | $components = collect($table->getColumns())->forget('can_send_money')->all() (L29) | 高 |

### 2.4 モデル定義に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| SoftDeletes使用 | BankAccount.php | use HasFactory, SoftDeletes (L15) | 高 |
| bankリレーション | BankAccount.php | public function bank(): BelongsTo (L49-52) | 高 |
| partnerリレーション | BankAccount.php | public function partner(): BelongsTo (L54-57) | 高 |
| creatorリレーション | BankAccount.php | public function creator(): BelongsTo (L59-62) | 高 |

### 2.5 account_holder_name自動設定に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| creating時の自動設定 | BankAccount.php | static::creating(function ($bankAccount) { $bankAccount->account_holder_name = $bankAccount->partner->name; }) (L71-73) | 高 |
| updating時の自動設定 | BankAccount.php | static::updating(function ($bankAccount) { $bankAccount->account_holder_name = $bankAccount->partner->name; }) (L75-77) | 高 |

### 2.6 テーブル機能に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| グループ化機能 | BankAccountResource.php (partners) | Group::make('bank.name'), Group::make('can_send_money'), Group::make('created_at') (L125-133) | 高 |
| フィルター機能 | BankAccountResource.php (partners) | TernaryFilter, SelectFilter (L134-151) | 高 |
| 削除済み表示対応 | BankAccountResource.php (partners) | modifyQueryUsing: fn (Builder $query) => $query->withTrashed() (L63) | 高 |
| (Deleted)ラベル | BankAccountResource.php (partners) | $record->name.($record->trashed() ? ' (Deleted)' : '') (L65-67) | 高 |

### 2.7 一括操作に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| RestoreBulkAction | BankAccountResource.php (partners) | RestoreBulkAction::make() (L186-192) | 高 |
| DeleteBulkAction | BankAccountResource.php (partners) | DeleteBulkAction::make() (L193-199) | 高 |
| ForceDeleteBulkAction | BankAccountResource.php (partners) | ForceDeleteBulkAction::make() (L200-206) | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 20 | 100% |
| 中 | 0 | 0% |
| 低 | 0 | 0% |

### 3.2 未確認事項

なし

## 4. ソースコード参照

### 4.1 accounts版BankAccountResource

```php
// plugins/webkul/accounts/src/Filament/Resources/BankAccountResource.php
class BankAccountResource extends BaseBankAccountResource
{
    protected static bool $shouldRegisterNavigation = false;

    public static function form(Schema $schema): Schema
    {
        $schema = BaseBankAccountResource::form($schema);
        $components = collect($schema->getComponents())->forget(1)->all();
        $schema->components($components);
        return $schema;
    }

    public static function table(Table $table): Table
    {
        $table = BaseBankAccountResource::table($table);
        $components = collect($table->getColumns())->forget('can_send_money')->all();
        $table->columns($components);
        return $table;
    }
}
```

### 4.2 BankAccountモデル - 自動設定

```php
// plugins/webkul/partners/src/Models/BankAccount.php
protected static function boot()
{
    parent::boot();

    static::creating(function ($bankAccount) {
        $bankAccount->account_holder_name = $bankAccount->partner->name;
    });

    static::updating(function ($bankAccount) {
        $bankAccount->account_holder_name = $bankAccount->partner->name;
    });
}
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき100%の信頼度で検証された。銀行口座管理機能は、partnersプラグインの基盤機能を継承しつつ、会計モジュール向けにカスタマイズされていることが確認できた。
