---
generated_at: 2025-12-26 12:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: F049 - 支払条件管理

## 1. 概要

本レポートは「F049 - 支払条件管理」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| accountsプラグインに属する | plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource.php | namespace Webkul\Account\Filament\Resources (L3) | 高 |
| PaymentTermモデルを使用 | PaymentTermResource.php | protected static ?string $model = PaymentTerm::class (L45) | 高 |

### 2.2 入出力仕様に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| テーブル名 | plugins/webkul/accounts/src/Models/PaymentTerm.php | protected $table = 'accounts_payment_terms' (L19) | 高 |
| name フィールド | PaymentTermResource.php | TextInput::make('name')->required() (L61-66) | 高 |
| early_discount フィールド | PaymentTermResource.php | Toggle::make('early_discount')->live() (L70-73) | 高 |
| discount_percentage フィールド | PaymentTermResource.php | TextInput::make('discount_percentage')->required()->numeric()->maxValue(100)->minValue(0) (L78-83) | 高 |
| discount_days フィールド | PaymentTermResource.php | TextInput::make('discount_days')->required()->integer() (L84-89) | 高 |
| early_pay_discount フィールド | PaymentTermResource.php | Select::make('early_pay_discount')->options(EarlyPayDiscount::class) (L96-99) | 高 |
| note フィールド | PaymentTermResource.php | RichEditor::make('note') (L101-102) | 高 |

### 2.3 動的フォーム表示に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| early_discount条件で表示 | PaymentTermResource.php | ->visible(fn (Get $get) => $get('early_discount')) (L76, L94) | 高 |

### 2.4 デフォルト期日条件自動生成に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| created時に自動生成 | PaymentTerm.php | static::created(function ($paymentTerm) { $paymentTerm->dueTerm()->create([...]) }) (L58-68) | 高 |
| value: percent | PaymentTerm.php | 'value' => DueTermValue::PERCENT->value (L60) | 高 |
| value_amount: 100 | PaymentTerm.php | 'value_amount' => 100 (L61) | 高 |
| delay_type: days_after | PaymentTerm.php | 'delay_type' => DelayType::DAYS_AFTER->value (L62) | 高 |
| days_next_month: 10 | PaymentTerm.php | 'days_next_month' => 10 (L63) | 高 |
| nb_days: 0 | PaymentTerm.php | 'nb_days' => 0 (L64) | 高 |

### 2.5 関連コンポーネントに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Sortable実装 | PaymentTerm.php | class PaymentTerm extends Model implements Sortable (L15) | 高 |
| SoftDeletes使用 | PaymentTerm.php | use HasFactory, SoftDeletes, SortableTrait (L17) | 高 |
| companyリレーション | PaymentTerm.php | public function company() (L39-42) | 高 |
| createdByリレーション | PaymentTerm.php | public function createdBy() (L44-47) | 高 |
| dueTermリレーション | PaymentTerm.php | public function dueTerm() (L49-52) | 高 |

### 2.6 ページ定義に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ListPaymentTerms | PaymentTermResource.php | 'index' => ListPaymentTerms::route('/') (L270) | 高 |
| CreatePaymentTerm | PaymentTermResource.php | 'create' => CreatePaymentTerm::route('/create') (L271) | 高 |
| ViewPaymentTerm | PaymentTermResource.php | 'view' => ViewPaymentTerm::route('/{record}') (L272) | 高 |
| EditPaymentTerm | PaymentTermResource.php | 'edit' => EditPaymentTerm::route('/{record}/edit') (L273) | 高 |
| ManagePaymentDueTerm | PaymentTermResource.php | 'payment-due-terms' => ManagePaymentDueTerm::route('/{record}/payment-due-terms') (L274) | 高 |

### 2.7 RelationManager関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| PaymentDueTermRelationManager | PaymentTermResource.php | use PaymentDueTermRelationManager (L40) | 高 |
| RelationGroup使用 | PaymentTermResource.php | RelationGroup::make('due_terms', [PaymentDueTermRelationManager::class]) (L258-261) | 高 |

### 2.8 グループ化機能に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| company.nameグループ | PaymentTermResource.php | Tables\Grouping\Group::make('company.name') (L131-133) | 高 |
| discount_daysグループ | PaymentTermResource.php | Tables\Grouping\Group::make('discount_days') (L134-136) | 高 |
| early_pay_discountグループ | PaymentTermResource.php | Tables\Grouping\Group::make('early_pay_discount') (L137-139) | 高 |
| nameグループ | PaymentTermResource.php | Tables\Grouping\Group::make('name') (L140-142) | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 24 | 100% |
| 中 | 0 | 0% |
| 低 | 0 | 0% |

### 3.2 未確認事項

なし

## 4. ソースコード参照

### 4.1 PaymentTermモデル - デフォルト期日条件生成

```php
// plugins/webkul/accounts/src/Models/PaymentTerm.php
protected static function boot()
{
    parent::boot();

    static::created(function ($paymentTerm) {
        $paymentTerm->dueTerm()->create([
            'value'           => DueTermValue::PERCENT->value,
            'value_amount'    => 100,
            'delay_type'      => DelayType::DAYS_AFTER->value,
            'days_next_month' => 10,
            'nb_days'         => 0,
            'payment_id'      => $paymentTerm->id,
        ]);
    });
}
```

### 4.2 早期割引の動的表示

```php
// plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource.php
Group::make()
    ->visible(fn (Get $get) => $get('early_discount'))
    ->schema([
        TextInput::make('discount_percentage')
            ->required()
            ->numeric()
            ->maxValue(100)
            ->minValue(0)
            ->suffix(__('%'))
            ->hiddenLabel(),
        TextInput::make('discount_days')
            ->required()
            ->integer()
            ->minValue(0)
            ->prefix(__('If paid within'))
            ->suffix(__('days'))
            ->hiddenLabel(),
    ])->columns(4),
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき100%の信頼度で検証された。支払条件管理機能の実装は設計書の記載と完全に一致しており、デフォルト期日条件の自動生成ロジックや動的フォーム表示も確認できた。
