---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート: チーム管理機能設計書

## 1. 概要

本レポートは「チーム管理」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| チーム管理Filamentリソース | plugins/webkul/security/src/Filament/Resources/TeamResource.php | `class TeamResource extends Resource` | 高 |
| チームモデル定義 | plugins/webkul/security/src/Models/Team.php | `class Team extends Model` | 高 |

### 2.2 データ構造の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| nameカラム | plugins/webkul/security/src/Models/Team.php | `protected $fillable = ['name']` | 高 |
| 多対多リレーション | 同上 | `public function users(): BelongsToMany` | 高 |
| 中間テーブル名 | 同上 | `belongsToMany(User::class, 'user_team', 'team_id', 'user_id')` | 高 |

### 2.3 リレーションの根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Team -> Users | plugins/webkul/security/src/Models/Team.php | `public function users(): BelongsToMany` | 高 |
| User -> Teams | plugins/webkul/security/src/Models/User.php | `public function teams(): BelongsToMany` | 高 |
| 中間テーブル構造 | 両モデル | 'user_team' テーブルを使用 | 高 |

### 2.4 マイグレーションの根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| teamsテーブル | plugins/webkul/security/database/migrations/2024_11_12_125715_create_teams_table.php | マイグレーションファイル存在 | 高 |

## 3. ソースコード参照

### Team.php
```php
// plugins/webkul/security/src/Models/Team.php
namespace Webkul\Security\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Team extends Model
{
    /**
     * Fillable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
    ];

    /**
     * The users that belong to the team.
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'user_team', 'team_id', 'user_id');
    }
}
```

### User.php（チーム関連部分）
```php
// plugins/webkul/security/src/Models/User.php
public function teams(): BelongsToMany
{
    return $this->belongsToMany(Team::class, 'user_team', 'user_id', 'team_id');
}
```

## 4. 根拠のない記述

| 記述内容 | 理由 | 推奨対応 |
|----------|------|----------|
| 監査ログ記録（推奨） | 具体的な監査ログ実装コード未確認 | セキュリティ要件として記載、実装確認必要 |

## 5. 信頼度評価

- **高信頼度（13件）**: ソースコードから直接確認できる記述
- **低信頼度（1件）**: 推奨事項としての記載

**総合信頼度: 93%**

## 6. 補足事項

チーム管理機能はシンプルな設計で、基本的なCRUD操作とユーザーとの多対多リレーションを提供している。モデル定義はコンパクトで、fillableはnameのみである。
