---
generated_at: 2025-12-26 12:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: F050 - 請求書管理(仕入)

## 1. 概要

本レポートは「F050 - 請求書管理(仕入)」機能設計書の記載内容について、ソースコードに基づく根拠を提示するものである。

## 2. 根拠一覧

### 2.1 機能概要に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| invoicesプラグインに属する | plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/BillResource.php | namespace Webkul\Invoice\Filament\Clusters\Vendors\Resources (L3) | 高 |
| accountsのBillResourceを継承 | BillResource.php (invoices) | class BillResource extends BaseBillResource (L17) | 高 |
| BaseBillResource使用 | BillResource.php (invoices) | use Webkul\Account\Filament\Resources\BillResource as BaseBillResource (L8) | 高 |
| Billモデル使用 | BillResource.php (invoices) | protected static ?string $model = Bill::class (L19) | 高 |

### 2.2 クラスター設定に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Vendorsクラスター | BillResource.php (invoices) | protected static ?string $cluster = Vendors::class (L27) | 高 |
| ナビゲーション登録 | BillResource.php (invoices) | protected static bool $shouldRegisterNavigation = true (L23) | 高 |
| navigationSort: 1 | BillResource.php (invoices) | protected static ?int $navigationSort = 1 (L25) | 高 |

### 2.3 仕入先フィルタリングに関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| sub_type: supplierでフィルタ | BillResource.php (accounts) | fn ($query) => $query->where('sub_type', 'supplier') (L123-124) | 高 |

### 2.4 仕入先選択時の自動設定に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 銀行口座自動設定 | BillResource.php (accounts) | $set('partner_bank_id', $partner?->bankAccounts->first()?->id) (L132) | 高 |
| 支払方法自動設定 | BillResource.php (accounts) | $set('preferred_payment_method_line_id', $partner?->propertyOutboundPaymentMethodLine?->id) (L133) | 高 |
| 支払条件自動設定 | BillResource.php (accounts) | $set('invoice_payment_term_id', $partner?->propertySupplierPaymentTerm?->id) (L134) | 高 |

### 2.5 商品選択時の自動設定に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 単位自動設定 | BillResource.php (accounts) | $set('uom_id', $product->uom_id) (L676) | 高 |
| 単価自動設定（cost/price） | BillResource.php (accounts) | $priceUnit = static::calculateUnitPrice($get('uom_id'), $product->cost ?: $product->price) (L678) | 高 |
| 税自動設定 | BillResource.php (accounts) | $set('taxes', $product->productTaxes->pluck('id')->toArray()) (L682) | 高 |

### 2.6 仕入税の適用に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| TypeTaxUse::PURCHASE | BillResource.php (accounts) | return $query->where('type_tax_use', TypeTaxUse::PURCHASE->value) (L612-613) | 高 |

### 2.7 請求書番号採番に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| BILL/YYYY/MM形式 | Move.php | 'BILL/'.$suffix (L398) | 高 |

### 2.8 ページ定義に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ListBills | BillResource.php (invoices) | 'index' => ListBills::route('/') (L72) | 高 |
| CreateBill | BillResource.php (invoices) | 'create' => CreateBill::route('/create') (L73) | 高 |
| EditBill | BillResource.php (invoices) | 'edit' => EditBill::route('/{record}/edit') (L74) | 高 |
| ViewBill | BillResource.php (invoices) | 'view' => ViewBill::route('/{record}') (L75) | 高 |

### 2.9 商品リンク機能に関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| extraItemActions | BillResource.php (invoices) | ->extraItemActions([Action::make('openProduct')...]) (L55-66) | 高 |
| 別タブで開く | BillResource.php (invoices) | ->openUrlInNewTab() (L63) | 高 |
| ProductResourceへリンク | BillResource.php (invoices) | ProductResource::getUrl('edit', ['record' => ...]) (L59-60) | 高 |

### 2.10 サブナビゲーション関する根拠

| 記載内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| getRecordSubNavigation | BillResource.php (invoices) | public static function getRecordSubNavigation(Page $page) (L44-50) | 高 |
| ViewBill, EditBill | BillResource.php (invoices) | [ViewBill::class, EditBill::class] (L46-48) | 高 |

## 3. 検証サマリー

### 3.1 信頼度分布

| 信頼度 | 件数 | 割合 |
|--------|------|------|
| 高 | 25 | 96% |
| 中 | 1 | 4% |
| 低 | 0 | 0% |

### 3.2 未確認事項

1. **Bill モデルの詳細**: Webkul\Invoice\Models\Bill の詳細実装は未確認だが、Moveを継承していると推測

## 4. ソースコード参照

### 4.1 invoices版BillResource

```php
// plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/BillResource.php
class BillResource extends BaseBillResource
{
    protected static ?string $model = Bill::class;
    protected static string|\BackedEnum|null $navigationIcon = 'heroicon-o-credit-card';
    protected static bool $shouldRegisterNavigation = true;
    protected static ?int $navigationSort = 1;
    protected static ?string $cluster = Vendors::class;

    public static function getProductRepeater(): Repeater
    {
        return parent::getProductRepeater()
            ->extraItemActions([
                Action::make('openProduct')
                    ->tooltip('Open product')
                    ->icon('heroicon-m-arrow-top-right-on-square')
                    ->url(fn (array $arguments, Get $get): ?string => ProductResource::getUrl('edit', [
                        'record' => $get("products.{$arguments['item']}.product_id"),
                    ]))
                    ->openUrlInNewTab()
                    ->visible(fn (array $arguments, Get $get): bool => filled($get("products.{$arguments['item']}.product_id"))),
            ]);
    }
}
```

### 4.2 仕入先選択時の自動設定

```php
// plugins/webkul/accounts/src/Filament/Resources/BillResource.php
Select::make('partner_id')
    ->relationship(
        'partner',
        'name',
        fn ($query) => $query->where('sub_type', 'supplier')->orderBy('id'),
    )
    ->afterStateUpdated(function (Set $set, $state) {
        $partner = $state ? Partner::find($state) : null;
        $set('partner_bank_id', $partner?->bankAccounts->first()?->id);
        $set('preferred_payment_method_line_id', $partner?->propertyOutboundPaymentMethodLine?->id);
        $set('invoice_payment_term_id', $partner?->propertySupplierPaymentTerm?->id);
    })
```

## 5. 結論

本機能設計書の記載内容は、ソースコードの調査に基づき96%の信頼度で検証された。仕入請求書管理機能は、accountsプラグインの基盤機能を継承しつつ、invoicesプラグイン向けにカスタマイズされていることが確認できた。商品リンク機能など、invoices固有の拡張も確認された。
