---
generated_at: 2025-12-26 23:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：51-顧客請求書管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **PDF生成処理の詳細仕様**：具体的な実装コード未確認
  2. **メール送信機能の詳細**：送信処理の実装詳細未確認
  3. **パフォーマンス要件の数値**：要件定義書未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Models/Invoice.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/InvoiceResource.php`
- E-03: `plugins/webkul/accounts/src/Models/Move.php`
- E-04: `plugins/webkul/accounts/src/Models/Payment.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `plugins/webkul/accounts/src/Enums/MoveType.php`
- E-08: `plugins/webkul/accounts/src/Enums/MoveState.php`
- E-09: `plugins/webkul/accounts/src/Enums/PaymentState.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Invoiceモデルは基底クラスMoveを継承している | E-01, E-03 | ○ |
| C-02 | 請求書番号はINV/YYYY/MM/ID形式で自動採番される | E-03 (updateSequencePrefix) | ○ |
| C-03 | move_type = 'out_invoice'で顧客請求書を識別 | E-03, E-07 | ○ |
| C-04 | InvoiceResourceはBaseInvoiceResourceを継承 | E-02 | ○ |
| C-05 | Customerクラスター配下にリソースが配置される | E-02 | ○ |
| C-06 | 請求書はドラフト/投稿/キャンセル状態を持つ | E-08 | ○ |
| C-07 | 支払状態は未払い/部分/完了/取消を持つ | E-09 | ○ |
| C-08 | paymentTermLineリレーションが存在する | E-01 | ○ |
| C-09 | HasChatter, HasLogActivityトレイトを使用 | E-03 | ○ |
| C-10 | HasCustomFieldsトレイトを使用 | E-03 | ○ |
| C-11 | accounts_account_movesテーブルを使用 | E-03 | ○ |
| C-12 | 関連画面としてPaymentsResourceが存在 | E-06 | ○ |
| C-13 | 関連画面としてPartnerResourceが存在 | E-06 | ○ |
| C-14 | 関連画面としてProductResourceが存在 | E-06 | ○ |
| C-15 | 機能一覧でF051として定義されている | E-05 | ○ |
| C-16 | 多通貨対応（currency_id） | E-03 | ○ |
| C-17 | インコターム対応（invoice_incoterm_id） | E-03 | ○ |
| C-18 | 支払条件との連携（invoice_payment_term_id） | E-03 | ○ |
| C-19 | 仕訳帳との連携（journal_id） | E-03 | ○ |
| C-20 | 金額計算フィールドが存在（amount_untaxed等） | E-03 | ○ |
| C-21 | Filament Formsによるフォーム入力 | E-02 | ○ |
| C-22 | グローバル検索属性が定義されている | E-02 | ○ |
| C-23 | PDF生成機能が存在する | **根拠なし** | △ |
| C-24 | メール送信機能が存在する | **根拠なし** | △ |
| C-25 | パフォーマンス要件（1秒/2秒/3秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PDF生成処理の具体的な実装コード
  - 候補：views/filament配下 / PDF生成ライブラリの設定ファイル / InvoiceActionクラス
- メール送信機能の実装詳細
  - 候補：Mailable クラス / 通知設定 / メールテンプレート
- パフォーマンス要件の根拠
  - 候補：要件定義書 / SLA文書 / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - PDF/メール送信機能の詳細仕様が未確認のため、実装との乖離可能性あり
- 0: 低リスク - 基本的なCRUD操作とデータモデルは実装コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] Invoiceモデルの継承構造が正しいか確認
- [ ] 請求書番号の採番ロジックが実装と一致するか確認
- [ ] PDF生成・メール送信機能の実装有無を確認
- [ ] パフォーマンス要件の妥当性を関係者に確認
- [ ] 権限制御の実装状況を確認
