---
generated_at: 2025-12-26 23:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：54-ベンダー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：要件定義書未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Models/Partner.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource.php`
- E-03: `plugins/webkul/invoices/src/Enums/AutoPostBills.php`
- E-04: `plugins/webkul/invoices/src/Enums/InvoiceFormat.php`
- E-05: `plugins/webkul/invoices/src/Enums/InvoiceSendingMethod.php`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PartnerモデルはBasePartnerを継承している | E-01 | ○ |
| C-02 | VendorResourceはBaseVendorResourceを継承 | E-02 | ○ |
| C-03 | sub_type = 'supplier' でフィルタ | E-02 | ○ |
| C-04 | Vendorsクラスター配下にリソースが配置 | E-02 | ○ |
| C-05 | navigationSort = 4で設定 | E-02 | ○ |
| C-06 | 販売・購買タブの設定フォームが存在 | E-02 | ○ |
| C-07 | 請求タブ（Invoicing）の設定フォームが存在 | E-02 | ○ |
| C-08 | 内部メモタブが存在 | E-02 | ○ |
| C-09 | InvoiceSendingMethod Enumが使用される | E-02, E-05 | ○ |
| C-10 | InvoiceFormat Enumが使用される | E-02, E-04 | ○ |
| C-11 | AutoPostBills Enumが使用される | E-02, E-03 | ○ |
| C-12 | property_payment_term_idフィールドが存在 | E-02 | ○ |
| C-13 | property_supplier_payment_term_idフィールドが存在 | E-02 | ○ |
| C-14 | property_account_position_idフィールドが存在 | E-02 | ○ |
| C-15 | BankAccountsRelationManagerが存在 | E-02 | ○ |
| C-16 | サブナビゲーションで連絡先・住所・銀行口座管理 | E-02 | ○ |
| C-17 | カード形式のグリッド表示に対応 | E-02 (contentGrid) | ○ |
| C-18 | 機能一覧でF054として定義されている | E-06 | ○ |
| C-19 | 関連画面としてBillResourceが存在 | E-07 | ○ |
| C-20 | 関連画面としてPaymentsResourceが存在 | E-07 | ○ |
| C-21 | Peppol EAS/Endpointフィールドが存在 | E-02 | ○ |
| C-22 | パフォーマンス要件（1秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の根拠
  - 候補：要件定義書 / SLA文書 / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD操作とデータモデルは実装コードと高い整合性

## 6) レビュアーチェックリスト（最小）
- [ ] VendorResourceの継承構造が正しいか確認
- [ ] sub_typeによるフィルタ条件が正しいか確認
- [ ] 請求設定（自動投稿、EDI等）の動作を確認
- [ ] サブナビゲーションの各ページが正しく動作するか確認
- [ ] 権限制御の実装状況を確認
