---
generated_at: 2025-12-26 23:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：55-商品管理(請求)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **請求ポリシーの詳細動作**：具体的な制御ロジック未確認
  2. **パフォーマンス要件の数値**：要件定義書未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Models/Product.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/ProductResource.php`
- E-03: `plugins/webkul/products/src/Models/Product.php`
- E-04: `plugins/webkul/invoices/src/Enums/InvoicePolicy.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProductモデルはBaseProductを継承している | E-01, E-03 | ○ |
| C-02 | HasChatter, HasCustomFields, HasLogActivityを使用 | E-01 | ○ |
| C-03 | productTaxesリレーションが存在 | E-01 | ○ |
| C-04 | supplierTaxesリレーションが存在 | E-01 | ○ |
| C-05 | accounts_product_taxes中間テーブルを使用 | E-01 | ○ |
| C-06 | accounts_product_supplier_taxes中間テーブルを使用 | E-01 | ○ |
| C-07 | property_account_income_idフィールドが存在 | E-01 | ○ |
| C-08 | property_account_expense_idフィールドが存在 | E-01 | ○ |
| C-09 | invoice_policyフィールドが存在 | E-01 | ○ |
| C-10 | sales_ok, purchase_okフィールドが存在 | E-01 | ○ |
| C-11 | ProductResourceはBaseProductResourceを継承 | E-02 | ○ |
| C-12 | Customerクラスター配下にリソースが配置 | E-02 | ○ |
| C-13 | サブナビゲーションで属性・バリエーション管理 | E-02 | ○ |
| C-14 | QueryBuilderフィルタからresponsibleを除外 | E-02 | ○ |
| C-15 | 機能一覧でF055として定義されている | E-05 | ○ |
| C-16 | 関連画面としてInvoiceResourceが存在 | E-06 | ○ |
| C-17 | 関連画面としてBillResourceが存在 | E-06 | ○ |
| C-18 | logAttributesで活動ログ対象属性を定義 | E-01 | ○ |
| C-19 | 請求ポリシーの具体的な制御ロジック | **根拠なし** | △ |
| C-20 | パフォーマンス要件（1秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 請求ポリシー（invoice_policy）の具体的な制御ロジック
  - 候補：請求書作成処理のコード / InvoicePolicyの使用箇所
- パフォーマンス要件の根拠
  - 候補：要件定義書 / SLA文書 / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD操作とデータモデルは実装コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] Productモデルの継承構造が正しいか確認
- [ ] 税リレーション（productTaxes/supplierTaxes）が正しく動作するか確認
- [ ] 会計科目との連携が正しいか確認
- [ ] 請求ポリシーの動作を確認
- [ ] 権限制御の実装状況を確認
