---
generated_at: 2025-12-26 23:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：56-インコターム管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：要件定義書未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Models/Incoterm.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/IncoTermResource.php`
- E-03: `plugins/webkul/accounts/src/Models/Incoterm.php`
- E-04: `plugins/webkul/accounts/src/Models/Move.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IncotermモデルはBaseIncotermを継承している | E-01, E-03 | ○ |
| C-02 | accounts_incotermsテーブルを使用 | E-03 | ○ |
| C-03 | code, nameフィールドが存在 | E-03 | ○ |
| C-04 | creator_idフィールドが存在 | E-03 | ○ |
| C-05 | SoftDeletesトレイトを使用 | E-03 | ○ |
| C-06 | IncoTermResourceはBaseIncoTermResourceを継承 | E-02 | ○ |
| C-07 | Configurationクラスター配下にリソースが配置 | E-02 | ○ |
| C-08 | 一覧ページのみ（ListIncoTerms） | E-02 | ○ |
| C-09 | 請求書でinvoice_incoterm_idとして参照 | E-04 | ○ |
| C-10 | invoiceIncotermリレーションがMoveに存在 | E-04 | ○ |
| C-11 | 機能一覧でF056として定義されている | E-05 | ○ |
| C-12 | HasFactoryトレイトを使用 | E-03 | ○ |
| C-13 | createdByリレーションが存在 | E-03 | ○ |
| C-14 | パフォーマンス要件（1秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の根拠
  - 候補：要件定義書 / SLA文書 / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなマスタ管理機能であり、実装コードと高い整合性

## 6) レビュアーチェックリスト（最小）
- [ ] Incotermモデルの継承構造が正しいか確認
- [ ] 一覧ページが正しく動作するか確認
- [ ] 請求書からのインコターム選択が正しく動作するか確認
- [ ] 論理削除が正しく動作するか確認
- [ ] 権限制御の実装状況を確認
