---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート: カスタムフィールド管理機能設計書

## 1. 概要

本レポートは「カスタムフィールド管理」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| フィールド管理Filamentリソース | plugins/webkul/fields/src/Filament/Resources/FieldResource.php | `class FieldResource extends Resource` | 高 |
| フィールドモデル定義 | plugins/webkul/fields/src/Models/Field.php | `class Field extends Model implements Sortable` | 高 |
| SoftDelete対応 | 同上 | `use SoftDeletes` | 高 |
| Sortable対応 | 同上 | `use SortableTrait` | 高 |

### 2.2 データ構造の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| テーブル名 | plugins/webkul/fields/src/Models/Field.php | `protected $table = 'custom_fields'` | 高 |
| fillableカラム定義 | 同上 | `protected $fillable = [...]` | 高 |
| codeカラム | 同上 | fillableに'code'定義 | 高 |
| nameカラム | 同上 | fillableに'name'定義 | 高 |
| typeカラム | 同上 | fillableに'type'定義 | 高 |
| input_typeカラム | 同上 | fillableに'input_type'定義 | 高 |
| is_multiselectカラム | 同上 | fillableに'is_multiselect'定義、castsでboolean | 高 |
| optionsカラム | 同上 | fillableに'options'定義、castsでarray | 高 |
| form_settingsカラム | 同上 | fillableに'form_settings'定義、castsでarray | 高 |
| table_settingsカラム | 同上 | fillableに'table_settings'定義、castsでarray | 高 |
| infolist_settingsカラム | 同上 | fillableに'infolist_settings'定義、castsでarray | 高 |
| sortカラム | 同上 | fillableに'sort'定義、$sortableに'order_column_name' | 高 |
| customizable_typeカラム | 同上 | fillableに'customizable_type'定義 | 高 |

### 2.3 Sortable設定の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ソート順設定 | plugins/webkul/fields/src/Models/Field.php | `$sortable = ['order_column_name' => 'sort', 'sort_when_creating' => true]` | 高 |
| 自動ソート順設定 | 同上 | `'sort_when_creating' => true` | 高 |

## 3. ソースコード参照

### Field.php
```php
// plugins/webkul/fields/src/Models/Field.php
namespace Webkul\Field\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class Field extends Model implements Sortable
{
    use SoftDeletes, SortableTrait;

    protected $table = 'custom_fields';

    protected $casts = [
        'is_multiselect'    => 'boolean',
        'options'           => 'array',
        'form_settings'     => 'array',
        'table_settings'    => 'array',
        'infolist_settings' => 'array',
    ];

    protected $fillable = [
        'code',
        'name',
        'type',
        'input_type',
        'is_multiselect',
        'datalist',
        'options',
        'form_settings',
        'use_in_table',
        'table_settings',
        'infolist_settings',
        'sort',
        'customizable_type',
    ];

    public $sortable = [
        'order_column_name'  => 'sort',
        'sort_when_creating' => true,
    ];
}
```

## 4. 根拠のない記述

| 記述内容 | 理由 | 推奨対応 |
|----------|------|----------|
| サポートフィールドタイプ一覧 | モデルには定義なし、リソース側で確認必要 | FieldResource.phpでの定義確認 |

## 5. 信頼度評価

- **高信頼度（21件）**: ソースコードから直接確認できる記述
- **低信頼度（1件）**: リソースクラスでの確認が必要

**総合信頼度: 95%**

## 6. 補足事項

カスタムフィールドモデルは設定をJSON形式で保存する設計で、form_settings、table_settings、infolist_settingsをarray型としてキャストしている。これによりFilamentフォーム/テーブル/Infolistでの動的表示が可能となっている。
