---
generated_at: 2025-12-26 23:25:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：64-パートナー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：推定値であり実測データなし
  2. **想定データ量**：推定値であり実際の運用データなし
  3. **各モジュールとの連携仕様**：詳細な仕様確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-02: `plugins/webkul/partners/src/Models/Partner.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/AddressResource.php`
- E-04: `plugins/webkul/partners/src/Enums/AccountType.php`
- E-05: `plugins/webkul/partners/src/Enums/AddressType.php`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パートナー管理はpartnersプラグインに属する | E-01, E-02, E-06 | ○ |
| C-02 | テーブル名はpartners_partners | E-02 | ○ |
| C-03 | account_typeはAccountType enumで定義 | E-02, E-04 | ○ |
| C-04 | SoftDeletesトレイトで論理削除を実装 | E-02 | ○ |
| C-05 | Authenticatableを継承 | E-02 | ○ |
| C-06 | FilamentUserインターフェースを実装 | E-02 | ○ |
| C-07 | HasChatterトレイトを使用 | E-02 | ○ |
| C-08 | HasLogActivityトレイトを使用 | E-02 | ○ |
| C-09 | Notifiableトレイトを使用 | E-02 | ○ |
| C-10 | fillable属性が適切に定義されている | E-02 | ○ |
| C-11 | countryリレーションはbelongsTo | E-02 | ○ |
| C-12 | stateリレーションはbelongsTo | E-02 | ○ |
| C-13 | parentリレーションはbelongsTo（自己参照） | E-02 | ○ |
| C-14 | creatorリレーションはbelongsTo | E-02 | ○ |
| C-15 | userリレーションはbelongsTo | E-02 | ○ |
| C-16 | titleリレーションはbelongsTo | E-02 | ○ |
| C-17 | companyリレーションはbelongsTo | E-02 | ○ |
| C-18 | industryリレーションはbelongsTo | E-02 | ○ |
| C-19 | addressesリレーションはhasMany（account_type=ADDRESS条件） | E-02 | ○ |
| C-20 | contactsリレーションはhasMany（account_type!=ADDRESS条件） | E-02 | ○ |
| C-21 | bankAccountsリレーションはhasMany | E-02 | ○ |
| C-22 | tagsリレーションはbelongsToMany | E-02 | ○ |
| C-23 | getAvatarUrlAttributeアクセサが定義されている | E-02 | ○ |
| C-24 | canAccessPanelメソッドがtrueを返す | E-02 | ○ |
| C-25 | AddressResourceでRadioタイプで住所タイプを選択 | E-03 | ○ |
| C-26 | パフォーマンス要件（2秒以内等） | **根拠なし** | △ |
| C-27 | 想定データ量（10000件程度） | **根拠なし** | △ |
| C-28 | 各モジュールとの連携仕様 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体値
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 想定データ量
  - 候補：運用実績データ / 要件定義書 / 業務分析資料
- 各モジュールとの連携仕様
  - 候補：販売・購買・人事モジュールのソースコード / 業務フロー図

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードから確認可能
- 0: 低リスク - モデル・リレーションは適切に定義されている
- 1: 中リスク - canAccessPanelが常にtrueを返すセキュリティ上の考慮が必要

## 6) レビュアーチェックリスト（最小）
- [ ] AccountTypeのenum値が業務要件を満たしているか確認
- [ ] 住所・連絡先の階層構造が業務で適切に運用できるか確認
- [ ] canAccessPanelが常にtrueを返す実装のセキュリティリスク評価
- [ ] 各モジュール（販売・購買・人事）からの参照方法が適切か確認
- [ ] 論理削除されたパートナーの扱い（他モジュールでの参照時）を確認
