---
generated_at: 2025-12-26 23:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：65-住所管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：推定値であり実測データなし
  2. **想定データ量**：推定値であり実際の運用データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/partners/src/Filament/Resources/AddressResource.php`
- E-02: `plugins/webkul/partners/src/Models/Partner.php`
- E-03: `plugins/webkul/partners/src/Enums/AddressType.php`
- E-04: `plugins/webkul/partners/src/Enums/AccountType.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 住所管理はpartnersプラグインに属する | E-01, E-05 | ○ |
| C-02 | 住所はpartners_partnersテーブルの子レコード | E-01, E-02 | ○ |
| C-03 | account_type=ADDRESSで住所を識別 | E-01, E-04 | ○ |
| C-04 | sub_typeはAddressType enumで定義 | E-01, E-03 | ○ |
| C-05 | sub_typeのデフォルトはINVOICE | E-01 | ○ |
| C-06 | Radioコンポーネントでsub_typeを選択 | E-01 | ○ |
| C-07 | parent_idで親パートナーと関連付け | E-01 | ○ |
| C-08 | ManageAddressesではparent_idが非表示 | E-01 | ○ |
| C-09 | name項目は必須、最大255文字 | E-01 | ○ |
| C-10 | email項目はメール形式バリデーション | E-01 | ○ |
| C-11 | phone項目はtel形式 | E-01 | ○ |
| C-12 | mobile項目はtel形式 | E-01 | ○ |
| C-13 | country_idで国と関連付け | E-01 | ○ |
| C-14 | state_idはcountry_idに依存してフィルタ | E-01 | ○ |
| C-15 | テーブルにsub_type列が表示される | E-01 | ○ |
| C-16 | テーブルにname列が表示される | E-01 | ○ |
| C-17 | テーブルにcountry.name列が表示される | E-01 | ○ |
| C-18 | CreateAction/EditAction/DeleteActionが定義されている | E-01 | ○ |
| C-19 | 一括削除機能が存在 | E-01 | ○ |
| C-20 | creator_idはAuth::id()で自動設定 | E-01 | ○ |
| C-21 | パフォーマンス要件（1秒以内等） | **根拠なし** | △ |
| C-22 | 想定データ量（5000件程度） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体値
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 想定データ量
  - 候補：運用実績データ / 要件定義書 / 業務分析資料

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードから確認可能
- 0: 低リスク - フォーム・テーブルは適切に実装されている
- 0: 低リスク - 住所タイプの選択肢が明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] AddressType enumの値（INVOICE/DELIVERY/OTHER等）が業務要件を満たしているか確認
- [ ] 販売・購買モジュールで住所タイプに応じた住所選択ができるか確認
- [ ] 都道府県フィルタリングが正しく動作するか確認
- [ ] 親パートナー削除時の住所の扱いを確認
