---
generated_at: 2025-12-26 23:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：66-連絡先管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **ContactResourceの実装確認**：専用のContactResourceの実装状況
  2. **パフォーマンス要件の具体値**：推定値であり実測データなし
  3. **想定データ量**：推定値であり実際の運用データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/partners/src/Models/Partner.php`
- E-02: `plugins/webkul/partners/src/Enums/AccountType.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 連絡先管理はpartnersプラグインに属する | E-01, E-03 | ○ |
| C-02 | 連絡先はpartners_partnersテーブルの子レコード | E-01 | ○ |
| C-03 | contacts()リレーションで連絡先を取得 | E-01 | ○ |
| C-04 | account_type != ADDRESSで連絡先を識別 | E-01, E-02 | ○ |
| C-05 | parent_idで親パートナーと関連付け | E-01 | ○ |
| C-06 | name項目が存在 | E-01 | ○ |
| C-07 | job_title項目が存在 | E-01 | ○ |
| C-08 | email項目が存在 | E-01 | ○ |
| C-09 | phone項目が存在 | E-01 | ○ |
| C-10 | mobile項目が存在 | E-01 | ○ |
| C-11 | country_id/state_idで住所と関連付け | E-01 | ○ |
| C-12 | street1/street2/city/zip項目が存在 | E-01 | ○ |
| C-13 | creator_idで作成者と関連付け | E-01 | ○ |
| C-14 | HasChatter/HasLogActivityトレイトを使用 | E-01 | ○ |
| C-15 | SoftDeletesトレイトで論理削除を実装 | E-01 | ○ |
| C-16 | ContactResourceの専用実装 | **根拠不足（確認必要）** | △ |
| C-17 | パフォーマンス要件（1秒以内等） | **根拠なし** | △ |
| C-18 | 想定データ量（10000件程度） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ContactResourceの実装詳細
  - 候補：専用のContactResourceファイル / ManageContactsページの実装
- パフォーマンス要件の具体値
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 想定データ量
  - 候補：運用実績データ / 要件定義書 / 業務分析資料

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Partnerモデルにcontacts()リレーションが定義されている
- 1: 中リスク - 専用のContactResource実装の有無を確認が必要
- 0: 低リスク - 住所との区別ロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] ContactResourceまたはManageContactsの実装を確認
- [ ] 連絡先と住所の区別が正しく行われているか確認
- [ ] 親パートナー削除時の連絡先の扱いを確認
- [ ] 販売・購買モジュールで連絡先選択ができるか確認
