---
generated_at: 2025-12-26 23:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：68-従業員管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：推定値であり実測データなし
  2. **想定データ量**：推定値であり実際の運用データなし
  3. **パートナー同期の詳細仕様**：エラー時の挙動確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/employees/src/Filament/Resources/EmployeeResource.php`
- E-02: `plugins/webkul/employees/src/Models/Employee.php`
- E-03: `plugins/webkul/employees/src/Enums/Gender.php`
- E-04: `plugins/webkul/employees/src/Enums/MaritalStatus.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 従業員管理はemployeesプラグインに属する | E-01, E-02, E-05 | ○ |
| C-02 | テーブル名はemployees_employees | E-02 | ○ |
| C-03 | SoftDeletesトレイトで論理削除を実装 | E-02 | ○ |
| C-04 | HasChatterトレイトを使用 | E-02 | ○ |
| C-05 | HasLogActivityトレイトを使用 | E-02 | ○ |
| C-06 | HasCustomFieldsトレイトを使用 | E-02 | ○ |
| C-07 | fillable属性に多数の項目が定義されている | E-02 | ○ |
| C-08 | departmentリレーションはbelongsTo | E-02 | ○ |
| C-09 | jobリレーションはbelongsTo | E-02 | ○ |
| C-10 | parentリレーションはbelongsTo（自己参照） | E-02 | ○ |
| C-11 | coachリレーションはbelongsTo（自己参照） | E-02 | ○ |
| C-12 | companyリレーションはbelongsTo | E-02 | ○ |
| C-13 | partnerリレーションはbelongsTo | E-02 | ○ |
| C-14 | skillsリレーションはhasMany | E-02 | ○ |
| C-15 | resumesリレーションはhasMany | E-02 | ○ |
| C-16 | categoriesリレーションはbelongsToMany | E-02 | ○ |
| C-17 | boot()でパートナー自動生成処理が定義 | E-02 | ○ |
| C-18 | handlePartnerCreationメソッドが存在 | E-02 | ○ |
| C-19 | handlePartnerUpdationメソッドが存在 | E-02 | ○ |
| C-20 | account_type='individual'で生成 | E-02 | ○ |
| C-21 | sub_type='employee'で生成 | E-02 | ○ |
| C-22 | leaveManagerリレーションが存在 | E-02 | ○ |
| C-23 | attendanceManagerリレーションが存在 | E-02 | ○ |
| C-24 | companyAddressリレーションが存在 | E-02 | ○ |
| C-25 | is_activeフラグでbooleanキャスト | E-02 | ○ |
| C-26 | is_flexibleフラグでbooleanキャスト | E-02 | ○ |
| C-27 | is_fully_flexibleフラグでbooleanキャスト | E-02 | ○ |
| C-28 | EmployeeFactoryが定義されている | E-02 | ○ |
| C-29 | Filamentリソースでフォーム定義 | E-01 | ○ |
| C-30 | タブでセクション分割（勤務情報、個人情報等） | E-01 | ○ |
| C-31 | グローバル検索対応 | E-01 | ○ |
| C-32 | サブナビゲーションでResume/Skill管理 | E-01 | ○ |
| C-33 | パフォーマンス要件（2秒以内等） | **根拠なし** | △ |
| C-34 | 想定データ量（1000件程度） | **根拠なし** | △ |
| C-35 | パートナー生成エラー時のロールバック | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体値
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 想定データ量
  - 候補：運用実績データ / 要件定義書 / 業務分析資料
- パートナー生成エラー時のロールバック仕様
  - 候補：トランザクション設定の確認 / エラーハンドリング実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードから確認可能
- 0: 低リスク - パートナー自動生成ロジックは明確
- 1: 中リスク - パートナー生成失敗時の挙動確認が必要
- 0: 低リスク - 多数のリレーションが適切に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] パートナー自動生成がトランザクション内で行われているか確認
- [ ] パートナー生成失敗時のエラーハンドリングを確認
- [ ] 従業員削除時のパートナーの扱い（削除/残留）を確認
- [ ] 個人情報項目へのアクセス権限が適切に制御されているか確認
- [ ] 上司・コーチ設定の自己参照・循環参照チェックを確認
