---
generated_at: 2025-12-26 12:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: テーブルビュー管理機能設計書

## 1. 概要

本レポートは「テーブルビュー管理」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| HasTableViewsトレイト | plugins/webkul/table-views/src/Filament/Concerns/HasTableViews.php | `trait HasTableViews` | 高 |
| ビュー作成機能 | 同上 | `createTableViewAction()` メソッド | 高 |
| ビュー編集機能 | 同上 | `editTableViewAction()` メソッド | 高 |
| ビュー削除機能 | 同上 | `deleteTableViewAction()` メソッド | 高 |
| ビュー適用機能 | 同上 | `applyTableViewAction()` メソッド | 高 |
| ビュー置き換え機能 | 同上 | `replaceTableViewAction()` メソッド | 高 |
| お気に入り追加 | 同上 | `addTableViewToFavoritesAction()` メソッド | 高 |
| お気に入り削除 | 同上 | `removeTableViewFromFavoritesAction()` メソッド | 高 |

### 2.2 データ構造の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| TableViewモデル | plugins/webkul/table-views/src/Models/TableView.php | `class TableView extends Model` | 高 |
| fillableカラム | 同上 | `protected $fillable = ['name', 'icon', 'color', 'is_public', 'filters', 'filterable_type', 'user_id']` | 高 |
| filters JSONキャスト | 同上 | `protected $casts = ['filters' => 'array']` | 高 |
| userリレーション | 同上 | `public function user()` - belongsTo | 高 |

### 2.3 filters設定の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| tableFilters保存 | HasTableViews.php | `'tableFilters' => $this->tableFilters` | 高 |
| tableGrouping保存 | 同上 | `'tableGrouping' => $this->tableGrouping` | 高 |
| tableSearch保存 | 同上 | `'tableSearch' => $this->tableSearch` | 高 |
| tableColumnSearches保存 | 同上 | `'tableColumnSearches' => $this->tableColumnSearches` | 高 |
| tableSort保存 | 同上 | `'tableSort' => $this->tableSort` | 高 |
| tableRecordsPerPage保存 | 同上 | `'tableRecordsPerPage' => $this->tableRecordsPerPage` | 高 |

### 2.4 ビュー取得の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 保存済みビュー取得 | HasTableViews.php | `getSavedTableViews()` メソッド | 高 |
| 公開ビュー条件 | 同上 | `->orWhere('is_public', true)` | 高 |
| ユーザーIDフィルタ | 同上 | `->where('user_id', filament()->auth()->id())` | 高 |
| filterable_typeフィルタ | 同上 | `->where('filterable_type', static::class)` | 高 |

### 2.5 お気に入り機能の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| お気に入りビュー取得 | HasTableViews.php | `getFavoriteTableViews()` メソッド | 高 |
| お気に入り追加処理 | 同上 | `TableViewFavoriteModel::updateOrCreate(...)` | 高 |
| デフォルトビュー | 同上 | `'default' => PresetView::make('default')` | 高 |

## 3. ソースコード参照

### TableView.php
```php
// plugins/webkul/table-views/src/Models/TableView.php
class TableView extends Model
{
    protected $fillable = [
        'name',
        'icon',
        'color',
        'is_public',
        'filters',
        'filterable_type',
        'user_id',
    ];

    protected $casts = [
        'filters' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
```

### HasTableViews.php（ビュー作成部分）
```php
// plugins/webkul/table-views/src/Filament/Concerns/HasTableViews.php
public function createTableViewAction(): Action
{
    return CreateViewAction::make('createTableView')
        ->mutateDataUsing(function (array $data): array {
            $data['user_id'] = filament()->auth()->id();
            $data['filterable_type'] = static::class;
            $data['filters'] = [
                'tableFilters'        => $this->tableFilters,
                'tableGrouping'       => $this->tableGrouping,
                'tableSearch'         => $this->tableSearch,
                'tableColumnSearches' => $this->tableColumnSearches,
                'tableSort'           => $this->tableSort,
                'tableRecordsPerPage' => $this->tableRecordsPerPage,
            ];
            return $data;
        })
        // ...
}
```

### HasTableViews.php（ビュー適用部分）
```php
public function applyTableViewFilters(): void
{
    $tableViews = $this->getAllTableViews();

    if (! array_key_exists($this->activeTableView, $tableViews)) {
        return;
    }

    if (! $tableViews[$this->activeTableView] instanceof SavedView) {
        return;
    }

    foreach ($tableViews[$this->activeTableView]->getRecord()->filters as $key => $filter) {
        if (! $filter) {
            continue;
        }

        $this->{$key} = $filter;
    }
}
```

## 4. 根拠のない記述

なし - 全ての記述がソースコードから確認できる。

## 5. 信頼度評価

- **高信頼度（28件）**: ソースコードから直接確認できる記述

**総合信頼度: 100%**

## 6. 補足事項

テーブルビュー機能はHasTableViewsトレイトを通じて各リソースの一覧ページに組み込まれる設計となっている。ビュー設定はJSON形式でfiltersカラムに保存され、適用時に各プロパティに展開される仕組み。
