---
generated_at: 2025-12-26 23:55:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：70-職位管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：推定値であり実測データなし
  2. **想定データ量**：推定値であり実際の運用データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/JobPositionResource.php`
- E-02: `plugins/webkul/employees/src/Models/EmployeeJobPosition.php`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 職位管理はemployeesプラグインに属する | E-01, E-02, E-03 | ○ |
| C-02 | テーブル名はemployees_job_positions | E-02 | ○ |
| C-03 | SoftDeletesトレイトで論理削除を実装 | E-02 | ○ |
| C-04 | SortableTraitでソート機能を実装 | E-02 | ○ |
| C-05 | HasCustomFieldsトレイトを使用 | E-02 | ○ |
| C-06 | fillable属性に適切な項目が定義 | E-02 | ○ |
| C-07 | createdByリレーションはbelongsTo | E-02 | ○ |
| C-08 | employeesリレーションはhasMany | E-02 | ○ |
| C-09 | departmentリレーションはbelongsTo | E-02 | ○ |
| C-10 | companyリレーションはbelongsTo | E-02 | ○ |
| C-11 | employmentTypeリレーションはbelongsTo | E-02 | ○ |
| C-12 | is_activeはbooleanキャスト | E-02 | ○ |
| C-13 | EmployeeJobPositionFactoryが定義されている | E-02 | ○ |
| C-14 | Configurationsクラスタに属する | E-01 | ○ |
| C-15 | name項目は必須、最大255文字 | E-01 | ○ |
| C-16 | department_idでリレーション設定 | E-01 | ○ |
| C-17 | company_idでリレーション設定 | E-01 | ○ |
| C-18 | 部門選択時に会社を自動設定 | E-01 | ○ |
| C-19 | descriptionはRichEditor | E-01 | ○ |
| C-20 | requirementsはRichEditor | E-01 | ○ |
| C-21 | no_of_recruitmentは数値入力 | E-01 | ○ |
| C-22 | no_of_recruitmentは0以上 | E-01 | ○ |
| C-23 | is_activeはトグル | E-01 | ○ |
| C-24 | テーブルにフィルタ機能あり | E-01 | ○ |
| C-25 | テーブルにグルーピング機能あり | E-01 | ○ |
| C-26 | 復元・完全削除アクションが存在 | E-01 | ○ |
| C-27 | 一括削除・復元機能が存在 | E-01 | ○ |
| C-28 | ドラッグ&ドロップ並び替え対応 | E-01 | ○ |
| C-29 | デフォルトソートはsort desc | E-01 | ○ |
| C-30 | 詳細画面（infolist）が定義されている | E-01 | ○ |
| C-31 | パフォーマンス要件（1秒以内等） | **根拠なし** | △ |
| C-32 | 想定データ量（50件程度） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体値
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 想定データ量
  - 候補：運用実績データ / 要件定義書 / 業務分析資料

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードから確認可能
- 0: 低リスク - フォーム・テーブル・詳細画面が適切に実装されている
- 0: 低リスク - ソート機能が適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 従業員が割り当てられている職位の削除時の挙動を確認
- [ ] 無効化された職位が従業員選択から除外されるか確認
- [ ] 採用目標と現在の従業員数の表示・計算が正しいか確認
- [ ] 部門選択時の会社自動設定が正しく動作するか確認
- [ ] リッチテキストエディタのXSS対策を確認
