---
generated_at: 2025-12-26 22:56:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：F074-勤務地管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/employees/src/Models/WorkLocation.php`
- E-02: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/WorkLocationResource.php`
- E-03: `plugins/webkul/employees/src/Enums/LocationType.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F074行)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-EMP-013行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名は employees_work_locations | E-01 (line 14) | ○ |
| C-02 | fillable項目: name, work_location_type, address_id, company_id, creator_id | E-01 (lines 16-22) | ○ |
| C-03 | SoftDeletesトレイトを使用 | E-01 (line 11) | ○ |
| C-04 | addressリレーションを持つ | E-01 (lines 30-33) | ○ |
| C-05 | companyリレーションを持つ | E-01 (lines 35-38) | ○ |
| C-06 | createdByリレーションを持つ | E-01 (lines 40-43) | ○ |
| C-07 | Filament Resourceで管理画面を提供 | E-02 | ○ |
| C-08 | name項目は必須 | E-02 (line 57) | ○ |
| C-09 | work_location_typeはLocationType Enumを使用 | E-02 (lines 60-63), E-03 | ○ |
| C-10 | 削除済み会社は選択可能だが無効化 | E-02 (lines 77-84) | ○ |
| C-11 | 論理削除・復元機能あり | E-02 (lines 163-169) | ○ |
| C-12 | 一括削除・強制削除機能あり | E-02 (lines 186-203) | ○ |
| C-13 | 機能カテゴリは人事管理 | E-04 | ○ |
| C-14 | 関連Resourceはemployees/WorkLocationResource | E-04, E-05 | ○ |
| C-15 | パフォーマンス要件：一覧取得1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：システム要件定義書 / 非機能要件定義書 / SLAドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデル・リソース定義に基づく記述が大半で信頼性高い

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が適切か確認
- [ ] 権限制御の記述が実装と一致しているか確認（Filament Shield設定確認推奨）
