---
generated_at: 2025-12-26 23:06:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：F079-応募者管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Models/Applicant.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource.php`
- E-03: `plugins/webkul/recruitments/src/Enums/ApplicationStatus.php`
- E-04: `plugins/webkul/recruitments/src/Enums/RecruitmentState.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (F079行)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-REC-001行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名は recruitments_applicants | E-01 (line 24) | ○ |
| C-02 | SoftDeletesトレイトを使用 | E-01 (line 22) | ○ |
| C-03 | HasChatter, HasLogActivityトレイトを使用 | E-01 (line 22) | ○ |
| C-04 | candidate_idは必須 | E-02 (lines 210-214) | ○ |
| C-05 | ProgressStepperでステージ管理 | E-02 (lines 94-127) | ○ |
| C-06 | 星評価（priority 0-3）の実装 | E-02 (lines 136-184) | ○ |
| C-07 | 採用ステージでsetAsHired処理 | E-02 (lines 113-114), E-01 (lines 157-159) | ○ |
| C-08 | 不採用処理でrefuse_reason_id設定 | E-01 (lines 162-167) | ○ |
| C-09 | application_statusの算出ロジック | E-01 (lines 184-195) | ○ |
| C-10 | BLOCKEDステータスの一覧除外 | E-02 (lines 695-700) | ○ |
| C-11 | 求人変更時の面接官継承 | E-02 (lines 269-271) | ○ |
| C-12 | 求人変更時のリクルーター継承 | E-02 (lines 265-267) | ○ |
| C-13 | 求人変更時の部門継承 | E-02 (lines 273-275) | ○ |
| C-14 | デフォルトステージの自動設定 | E-02 (lines 245-248, 256-258) | ○ |
| C-15 | 評価が候補者にも連動 | E-02 (lines 147-148, 161-162) | ○ |
| C-16 | ステージ更新時のトランザクション | E-02 (line 110) | ○ |
| C-17 | date_last_stage_updatedの更新 | E-02 (line 123) | ○ |
| C-18 | last_stage_idの更新 | E-02 (line 122) | ○ |
| C-19 | 給与情報（expected/proposed）の管理 | E-02 (lines 354-380), E-01 (lines 52-53, 66-68) | ○ |
| C-20 | SkillsRelationManagerの使用 | E-02 (lines 887-894) | ○ |
| C-21 | 面接官の複数選択（多対多） | E-02 (lines 294-302), E-01 (lines 122-125) | ○ |
| C-22 | カテゴリ（タグ）の複数選択 | E-02 (lines 303-316), E-01 (lines 127-130) | ○ |
| C-23 | ステージ別グルーピング | E-02 (lines 542-544, 651) | ○ |
| C-24 | createEmployee機能 | E-01 (lines 197-225) | ○ |
| C-25 | 応募経路（source）・メディア（medium）管理 | E-02 (lines 385-391), E-01 (lines 75-83) | ○ |
| C-26 | 機能カテゴリは採用管理 | E-05 | ○ |
| C-27 | 関連Resourceはrecruitments/ApplicantResource | E-05, E-06 | ○ |
| C-28 | パフォーマンス要件：一覧取得2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：システム要件定義書 / 非機能要件定義書 / SLAドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデル・リソース定義に基づく記述が大半で信頼性高い

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が適切か確認
- [ ] 権限制御の記述が実装と一致しているか確認（Filament Shield設定確認推奨）
- [ ] 採用プロセスのビジネスルールが実際の運用と一致しているか確認
