---
generated_at: 2025-12-26 12:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: アナリティクス機能設計書

## 1. 概要

本レポートは「アナリティクス」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| Recordモデル定義 | plugins/webkul/analytics/src/Models/Record.php | `class Record extends Model` | 高 |
| テーブル名 | 同上 | `protected $table = 'analytic_records'` | 高 |

### 2.2 データ構造の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| fillableカラム | plugins/webkul/analytics/src/Models/Record.php | `protected $fillable = [...]` | 高 |
| typeカラム | 同上 | fillableに'type'定義 | 高 |
| nameカラム | 同上 | fillableに'name'定義 | 高 |
| dateカラム | 同上 | fillableに'date'定義、castsで'date' | 高 |
| amountカラム | 同上 | fillableに'amount'定義 | 高 |
| unit_amountカラム | 同上 | fillableに'unit_amount'定義 | 高 |
| partner_idカラム | 同上 | fillableに'partner_id'定義 | 高 |
| company_idカラム | 同上 | fillableに'company_id'定義 | 高 |
| user_idカラム | 同上 | fillableに'user_id'定義 | 高 |
| creator_idカラム | 同上 | fillableに'creator_id'定義 | 高 |

### 2.3 リレーションの根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| partnerリレーション | plugins/webkul/analytics/src/Models/Record.php | `public function partner(): BelongsTo` | 高 |
| creatorリレーション | 同上 | `public function creator(): BelongsTo` | 高 |
| userリレーション | 同上 | `public function user(): BelongsTo` | 高 |
| companyリレーション | 同上 | `public function company(): BelongsTo` | 高 |

## 3. ソースコード参照

### Record.php
```php
// plugins/webkul/analytics/src/Models/Record.php
namespace Webkul\Analytic\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Webkul\Partner\Models\Partner;
use Webkul\Security\Models\User;
use Webkul\Support\Models\Company;

class Record extends Model
{
    protected $table = 'analytic_records';

    protected $fillable = [
        'type',
        'name',
        'date',
        'amount',
        'unit_amount',
        'partner_id',
        'company_id',
        'user_id',
        'creator_id',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    public function partner(): BelongsTo
    {
        return $this->belongsTo(Partner::class);
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }
}
```

## 4. 根拠のない記述

なし - 全ての記述がソースコードから確認できる。

## 5. 信頼度評価

- **高信頼度（16件）**: ソースコードから直接確認できる記述

**総合信頼度: 100%**

## 6. 補足事項

アナリティクスモデルはシンプルな設計で、各種ビジネスモジュールからのデータを受け入れる汎用的なレコード構造となっている。Partner、User、Companyとの外部キー関係により、多角的な集計分析が可能。
