---
generated_at: 2025-12-26 23:08:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：F080-求人管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Models/JobPosition.php`
- E-02: `plugins/webkul/employees/src/Models/EmployeeJobPosition.php`
- E-03: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/JobPositionResource.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (F080行)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (SCR-REC-002行)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseJobPositionを継承 | E-01 (line 14) | ○ |
| C-02 | fillable項目の拡張（address_id, manager_id, industry_id, recruiter_id, date_from, date_to） | E-01 (lines 22-30) | ○ |
| C-03 | addressリレーションを持つ | E-01 (lines 41-44) | ○ |
| C-04 | skillsリレーション（多対多） | E-01 (lines 46-49) | ○ |
| C-05 | interviewersリレーション（多対多） | E-01 (lines 51-54) | ○ |
| C-06 | managerリレーションを持つ | E-01 (lines 56-59) | ○ |
| C-07 | recruiterリレーションを持つ | E-01 (lines 61-64) | ○ |
| C-08 | industryリレーションを持つ | E-01 (lines 66-69) | ○ |
| C-09 | noOfEmployee Attributeの計算ロジック | E-01 (lines 71-82) | ○ |
| C-10 | noOfHiredEmployee Attributeの計算ロジック | E-01 (lines 84-98) | ○ |
| C-11 | expectedEmployees Attributeの計算ロジック | E-01 (lines 100-108) | ○ |
| C-12 | applicationsリレーションを持つ | E-01 (lines 110-113) | ○ |
| C-13 | 更新時のキャッシュクリア（boot） | E-01 (lines 115-123) | ○ |
| C-14 | name項目は必須 | E-03 (lines 91-96) | ○ |
| C-15 | 部門選択時のマネージャー・会社自動設定 | E-03 (lines 104-119) | ○ |
| C-16 | 説明・要件のリッチテキスト入力 | E-03 (lines 187-192) | ○ |
| C-17 | reorderable機能（sort列） | E-03 (lines 445-446) | ○ |
| C-18 | 論理削除・復元機能あり | E-03 (lines 402-408) | ○ |
| C-19 | 一括削除・強制削除機能あり | E-03 (lines 411-432) | ○ |
| C-20 | 削除済み会社は選択可能だが無効化 | E-03 (lines 133-143) | ○ |
| C-21 | グローバル検索結果の詳細情報 | E-03 (lines 70-79) | ○ |
| C-22 | 面接官の複数選択（多対多） | E-03 (lines 157-164) | ○ |
| C-23 | スキルの複数選択（多対多） | E-03 (lines 223-230) | ○ |
| C-24 | 機能カテゴリは採用管理 | E-04 | ○ |
| C-25 | 関連Resourceはrecruitments/JobPositionResource | E-04, E-05 | ○ |
| C-26 | パフォーマンス要件：一覧取得1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値根拠
  - 候補：システム要件定義書 / 非機能要件定義書 / SLAドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデル・リソース定義に基づく記述が大半で信頼性高い

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値が適切か確認
- [ ] 権限制御の記述が実装と一致しているか確認（Filament Shield設定確認推奨）
- [ ] 員数計算ロジックが実際の業務要件と一致しているか確認
