---
generated_at: 2025-12-26 23:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：81-候補者管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値基準の根拠不足
  2. **応募者変換機能**：将来機能としての記載は推測
  3. **エラーコード体系**：設計書独自の定義

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/recruitments/src/Models/Candidate.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/CandidateResource.php`
- E-03: `plugins/webkul/recruitments/database/migrations/2025_01_09_125852_create_recruitments_candidates_table.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 候補者情報はrecruitments_candidatesテーブルに保存 | E-01, E-03 | ○ |
| C-02 | 候補者モデルにname, email_from, phone等のフィールド存在 | E-01 | ○ |
| C-03 | パートナー自動作成機能が実装されている | E-01 | ○ |
| C-04 | SoftDeletesトレイトによる論理削除 | E-01 | ○ |
| C-05 | HasChatter, HasLogActivityトレイトを使用 | E-01 | ○ |
| C-06 | CandidateResourceでCRUD画面を提供 | E-02 | ○ |
| C-07 | 評価（priority）は星表示で0-3の範囲 | E-02 | ○ |
| C-08 | カテゴリ（タグ）の複数関連付けが可能 | E-01, E-02 | ○ |
| C-09 | 学位（degree）との関連を持つ | E-01, E-03 | ○ |
| C-10 | マネージャー（manager）との関連を持つ | E-01, E-03 | ○ |
| C-11 | スキル管理機能を持つ（SkillsRelationManager） | E-02 | ○ |
| C-12 | グローバル検索対象フィールドの定義 | E-02 | ○ |
| C-13 | QueryBuilderによるフィルタリング機能 | E-02 | ○ |
| C-14 | カード形式（Grid）での一覧表示 | E-02 | ○ |
| C-15 | createEmployeeメソッドによる従業員作成機能 | E-01 | ○ |
| C-16 | 機能一覧でF081として定義 | E-04 | ○ |
| C-17 | 画面マッピングでSCR-REC-002として定義 | E-05 | ○ |
| C-18 | availability_date（入社可能日）フィールド | E-01, E-03 | ○ |
| C-19 | linkedin_profileフィールドでURL管理 | E-01, E-03 | ○ |
| C-20 | company_idによる会社関連 | E-01, E-03 | ○ |
| C-21 | creator_idによる作成者追跡 | E-01, E-03 | ○ |
| C-22 | is_activeフラグによる有効/無効管理 | E-01, E-03 | ○ |
| C-23 | candidate_propertiesのJSON保存 | E-01, E-03 | ○ |
| C-24 | パートナー更新時の同期処理 | E-01 | ○ |
| C-25 | パフォーマンス要件（1秒以内レスポンス） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値
  - 候補：NFR文書 / パフォーマンステスト仕様書 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が充実

## 6) レビュアーチェックリスト（最小）
- [ ] パートナー自動作成/更新ロジックの動作確認
- [ ] 論理削除時の関連データ処理確認
- [ ] スキル管理機能の完全性確認
