---
generated_at: 2025-12-26 23:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-採用ステージ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全項目で根拠あり、特別なレビュー優先項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/recruitments/src/Models/Stage.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/StageResource.php`
- E-03: `plugins/webkul/recruitments/database/migrations/2025_01_06_133002_create_recruitments_stages_table.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ステージ情報はrecruitments_stagesテーブルに保存 | E-01, E-03 | ○ |
| C-02 | ステージモデルにname, requirements, legend_*フィールド存在 | E-01, E-03 | ○ |
| C-03 | SortableTrait使用でドラッグ＆ドロップ対応 | E-01, E-02 | ○ |
| C-04 | 求人職位との多対多関連（jobs） | E-01, E-02 | ○ |
| C-05 | fold（フォールド）設定が可能 | E-01, E-02, E-03 | ○ |
| C-06 | hired_stage（採用決定ステージ）フラグ | E-01, E-02, E-03 | ○ |
| C-07 | is_default（デフォルトステージ）フラグ | E-01, E-02 | ○ |
| C-08 | legend_normalのデフォルト値は"In Progress" | E-02 | ○ |
| C-09 | legend_blockedのデフォルト値は"Blocked" | E-02 | ○ |
| C-10 | legend_doneのデフォルト値は"Ready for Next Stage" | E-02 | ○ |
| C-11 | RichEditorによるrequirements入力 | E-02 | ○ |
| C-12 | QueryBuilderによるフィルタリング機能 | E-02 | ○ |
| C-13 | 削除時のQueryException処理 | E-02 | ○ |
| C-14 | グルーピング機能の提供 | E-02 | ○ |
| C-15 | 列の表示/非表示切り替え | E-02 | ○ |
| C-16 | creator_idによる作成者追跡 | E-01, E-03 | ○ |
| C-17 | 機能一覧でF082として定義 | E-04 | ○ |
| C-18 | 画面マッピングでSCR-REC-005として定義 | E-05 | ○ |
| C-19 | Infolist（詳細表示）でステージ情報表示 | E-02 | ○ |
| C-20 | 作成・編集・表示・一覧の4ページ構成 | E-02 | ○ |
| C-21 | Configurationsクラスター配下に配置 | E-02 | ○ |
| C-22 | BulkDeleteActionによる一括削除 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目で根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 削除時の関連チェックロジック確認
- [ ] デフォルトステージの一意性確認
- [ ] 採用決定ステージのビジネスロジック確認
