---
generated_at: 2025-12-26 23:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-学歴管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目で根拠あり、特別なレビュー優先項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/recruitments/src/Models/Degree.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/DegreeResource.php`
- E-03: `plugins/webkul/recruitments/database/migrations/2025_01_09_071817_create_recruitments_degrees_table.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 学歴情報はrecruitments_degreesテーブルに保存 | E-01, E-03 | ○ |
| C-02 | Degreeモデルにname, sort, creator_idフィールド存在 | E-01 | ○ |
| C-03 | SortableTrait使用でドラッグ＆ドロップ対応 | E-01 | ○ |
| C-04 | 作成者（createdBy）との関連 | E-01 | ○ |
| C-05 | 外部キー制約（creator_id）にnullOnDelete設定 | E-03 | ○ |
| C-06 | sortのデフォルト値は0 | E-03 | ○ |
| C-07 | TextInputでnameを入力 | E-02 | ○ |
| C-08 | 最大255文字のバリデーション | E-02 | ○ |
| C-09 | DegreeResourceで一覧画面を提供 | E-02 | ○ |
| C-10 | 編集・削除アクション対応 | E-02 | ○ |
| C-11 | BulkDeleteActionによる一括削除 | E-02 | ○ |
| C-12 | QueryBuilderによるフィルタリング | E-02 | ○ |
| C-13 | 列のtoggleable設定 | E-02 | ○ |
| C-14 | reorderable設定（降順） | E-02 | ○ |
| C-15 | Infolistでname表示 | E-02 | ○ |
| C-16 | ListDegreesページのみ（SimpleResource） | E-02 | ○ |
| C-17 | Configurationsクラスター配下 | E-02 | ○ |
| C-18 | 機能一覧でF083として定義 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目で根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 候補者削除時の学歴参照の動作確認
- [ ] シーダーデータの内容確認
- [ ] 学歴名の重複チェック有無の確認
