---
generated_at: 2025-12-26 23:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-不採用理由管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全項目で根拠あり、特別なレビュー優先項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/recruitments/src/Models/RefuseReason.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/RefuseReasonResource.php`
- E-03: `plugins/webkul/recruitments/database/migrations/2025_01_09_082748_create_recruitments_refuse_reasons_table.php`
- E-04: `plugins/webkul/recruitments/resources/views/mails/applicant-refuse.blade.php`
- E-05: `plugins/webkul/recruitments/resources/views/mails/applicant-not-interested.blade.php`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 不採用理由はrecruitments_refuse_reasonsテーブルに保存 | E-01, E-03 | ○ |
| C-02 | RefuseReasonモデルにname, template, is_activeフィールド存在 | E-01 | ○ |
| C-03 | SortableTrait使用でドラッグ＆ドロップ対応 | E-01 | ○ |
| C-04 | templateフィールドでメールテンプレート種別を管理 | E-01, E-02 | ○ |
| C-05 | is_activeフラグによる有効/無効管理 | E-01, E-03 | ○ |
| C-06 | 作成者（createdBy）との関連 | E-01 | ○ |
| C-07 | sortのデフォルト値は0 | E-03 | ○ |
| C-08 | applicant-refuseテンプレート選択肢存在 | E-02 | ○ |
| C-09 | applicant-not-interestedテンプレート選択肢存在 | E-02 | ○ |
| C-10 | テンプレートファイル（applicant-refuse.blade.php）存在 | E-04 | ○ |
| C-11 | テンプレートファイル（applicant-not-interested.blade.php）存在 | E-05 | ○ |
| C-12 | RefuseReasonResourceで一覧画面を提供 | E-02 | ○ |
| C-13 | 編集・削除アクション対応 | E-02 | ○ |
| C-14 | BulkDeleteActionによる一括削除 | E-02 | ○ |
| C-15 | QueryBuilderによるフィルタリング | E-02 | ○ |
| C-16 | reorderable設定（降順） | E-02 | ○ |
| C-17 | Infolistでname, template表示 | E-02 | ○ |
| C-18 | ListRefuseReasonsページのみ | E-02 | ○ |
| C-19 | Configurationsクラスター配下 | E-02 | ○ |
| C-20 | 機能一覧でF084として定義 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目で根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] メールテンプレートの内容確認
- [ ] 応募者不採用処理との連携確認
- [ ] テンプレート選択UIの動作確認
