---
generated_at: 2025-12-26 23:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-雇用形態管理（採用）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目で根拠あり、特別なレビュー優先項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/recruitments/src/Models/EmploymentType.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/EmploymentTypeResource.php`
- E-03: `plugins/webkul/employees/src/Models/EmploymentType.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 採用モジュールのEmploymentTypeは従業員モジュールを継承 | E-01 | ○ |
| C-02 | employees_employment_typesテーブルを使用 | E-03 | ○ |
| C-03 | ベースモデルにname, code, country_id, creator_idフィールド存在 | E-03 | ○ |
| C-04 | SortableTrait使用でドラッグ＆ドロップ対応 | E-03 | ○ |
| C-05 | 国（country）との関連 | E-03 | ○ |
| C-06 | 作成者（createdBy）との関連 | E-03 | ○ |
| C-07 | HasCustomFieldsトレイト使用 | E-03 | ○ |
| C-08 | BaseEmploymentTypeResourceを継承 | E-02 | ○ |
| C-09 | Configurationsクラスター配下 | E-02 | ○ |
| C-10 | navigationSort = 2 | E-02 | ○ |
| C-11 | ListEmploymentTypesページを使用 | E-02 | ○ |
| C-12 | ナビゲーショングループ設定のオーバーライド | E-02 | ○ |
| C-13 | 機能一覧でF086として定義 | E-04 | ○ |
| C-14 | recruitments::filament/clusters/configurationsの翻訳使用 | E-02 | ○ |
| C-15 | sortフィールドによる並び替え | E-03 | ○ |
| C-16 | モデル継承による共有マスタ実現 | E-01, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目で根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 従業員モジュールとのデータ共有確認
- [ ] 継承元リソースの機能確認
- [ ] 国選択UIの動作確認
