---
generated_at: 2025-12-26 23:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-UTMソース管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目で根拠あり、特別なレビュー優先項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/recruitments/src/Models/UTMSource.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/UTMSourceResource.php`
- E-03: `plugins/webkul/support/src/Models/UTMSource.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 採用モジュールのUTMSourceはサポートモジュールを継承 | E-01 | ○ |
| C-02 | utm_sourcesテーブルを使用 | E-03 | ○ |
| C-03 | ベースモデルにname, creator_idフィールド存在 | E-03 | ○ |
| C-04 | 作成者（createdBy）との関連 | E-03 | ○ |
| C-05 | UTMSourceResourceで一覧画面を提供 | E-02 | ○ |
| C-06 | TextInputでnameを入力（最大255文字） | E-02 | ○ |
| C-07 | 編集・削除アクション対応 | E-02 | ○ |
| C-08 | BulkDeleteActionによる一括削除 | E-02 | ○ |
| C-09 | QueryBuilderによるフィルタリング | E-02 | ○ |
| C-10 | 列のtoggleable設定 | E-02 | ○ |
| C-11 | ListUTMSourcesページのみ | E-02 | ○ |
| C-12 | Configurationsクラスター配下 | E-02 | ○ |
| C-13 | スラッグ設定：utm-source | E-02 | ○ |
| C-14 | Infolistでname表示 | E-02 | ○ |
| C-15 | 機能一覧でF088として定義 | E-04 | ○ |
| C-16 | 画面マッピングでSCR-REC-012として定義 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目で根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] サポートモジュールとのデータ共有確認
- [ ] 応募者との関連付け動作確認
- [ ] UTM分析機能との連携確認
