---
generated_at: 2025-12-26 12:40:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: チャッター機能設計書

## 1. 概要

本レポートは「チャッター」機能設計書の各記述について、ソースコードからの根拠を示すものである。

## 2. 根拠一覧

### 2.1 機能概要の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ChatterPanelコンポーネント | plugins/webkul/chatter/src/Livewire/ChatterPanel.php | `class ChatterPanel extends Component` | 高 |
| メッセージタブ/アクティビティタブ | 同上 | `public string $tab = 'messages'` | 高 |
| フィルタリング機能 | 同上 | `search`, `filterType`, `dateRange`, `pinnedOnly` プロパティ | 高 |
| ソート機能 | 同上 | `public string $sortBy = 'created_at_desc'` | 高 |

### 2.2 アクション機能の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ファイルアクション | ChatterPanel.php | `public function fileAction(): FileAction` | 高 |
| フォロワーアクション | 同上 | `public function followerAction(): FollowerAction` | 高 |
| フィルタアクション | 同上 | `public function filtersAction(): FiltersAction` | 高 |
| 完了マークアクション | 同上 | `public function markAsDoneAction(): Action` | 高 |
| アクティビティ編集アクション | 同上 | `public function editActivityAction(): Action` | 高 |
| メッセージ削除アクション | 同上 | `public function deleteMessageAction(): Action` | 高 |
| アクティビティキャンセルアクション | 同上 | `public function cancelActivityAction(): Action` | 高 |

### 2.3 フィルタ機能の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| 検索フィルタ | ChatterPanel.php | `public string $search = ''` | 高 |
| タイプフィルタ | 同上 | `public string $filterType = 'all'` | 高 |
| 日付範囲フィルタ | 同上 | `public ?string $dateRange = null` | 高 |
| ピン留めフィルタ | 同上 | `public bool $pinnedOnly = false` | 高 |
| 日付範囲オプション | 同上 | `getDateRangeLabel()` メソッドで today,yesterday,week,month,quarter,year | 高 |

### 2.4 ソート機能の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ソートオプション | ChatterPanel.php | `applySorting()` メソッドで created_at_asc, updated_at_desc, priority | 高 |
| ピン留め優先 | 同上 | `$pa = ! empty($a->pinned_at); if ($pa !== $pb) { return $pa ? -1 : 1; }` | 高 |

### 2.5 アクティビティ処理の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| アクティビティ完了処理 | ChatterPanel.php | `processMessage()` メソッド | 高 |
| 完了コメント作成 | 同上 | `$this->record->addMessage(['type' => 'comment', 'body' => ...])` | 高 |
| アクティビティ削除 | 同上 | `$message->delete()` | 高 |
| フィードバック入力 | 同上 | `TextInput::make('feedback')` | 高 |

### 2.6 ピン留め機能の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| ピン留めトグル | ChatterPanel.php | `public function pinMessage(int $id): void` | 高 |
| ピン留め更新 | 同上 | `$message->update(['pinned_at' => $message->pinned_at ? null : now()])` | 高 |

### 2.7 リフレッシュ機能の根拠

| 記述内容 | 根拠ファイル | 該当箇所 | 信頼度 |
|----------|--------------|----------|--------|
| リスナー定義 | ChatterPanel.php | `protected $listeners = ['chatter.refresh' => 'refreshMessages']` | 高 |
| リフレッシュ処理 | 同上 | `public function refreshMessages(): void` | 高 |
| dispatch更新 | 同上 | `$this->dispatch('$refresh')` | 高 |

## 3. ソースコード参照

### ChatterPanel.php（主要プロパティ）
```php
// plugins/webkul/chatter/src/Livewire/ChatterPanel.php
class ChatterPanel extends Component implements HasActions, HasForms, HasInfolists
{
    public Model $record;
    public string $resourceClass = '';
    public mixed $followerViewMailPath = null;
    public bool $isFollowerActionVisible;
    public bool $isFileActionVisible;
    public array $filters;
    public string $search = '';
    public string $filterType = 'all';
    public ?string $dateRange = null;
    public bool $pinnedOnly = false;
    public string $viewMode = 'detailed';
    public string $sortBy = 'created_at_desc';
    public string $tab = 'messages';
    public int $refreshTick = 0;
    // ...
}
```

### ChatterPanel.php（日付フィルタ）
```php
private function getDateRangeLabel(): string
{
    return match ($this->dateRange) {
        'today'     => 'Today',
        'yesterday' => 'Yesterday',
        'week'      => 'Last 7 days',
        'month'     => 'Last 30 days',
        'quarter'   => 'Last 3 months',
        'year'      => 'Last year',
        default     => 'Unknown range',
    };
}
```

### ChatterPanel.php（ソート処理）
```php
private function applySorting($state)
{
    return $state->sort(function ($a, $b) {
        $pa = ! empty($a->pinned_at);
        $pb = ! empty($b->pinned_at);

        if ($pa !== $pb) {
            return $pa ? -1 : 1;
        }

        return match ($this->sortBy) {
            'created_at_asc'  => $a->created_at <=> $b->created_at,
            'updated_at_desc' => $b->updated_at <=> $a->updated_at,
            'priority'        => $this->comparePriority($a, $b),
            default           => $b->created_at <=> $a->created_at,
        };
    })->values();
}
```

## 4. 根拠のない記述

| 記述内容 | 理由 | 推奨対応 |
|----------|------|----------|
| messagesテーブル詳細定義 | Messageモデルの詳細確認が必要 | マイグレーションファイルの確認 |

## 5. 信頼度評価

- **高信頼度（31件）**: ソースコードから直接確認できる記述
- **低信頼度（1件）**: テーブル定義の詳細確認が必要

**総合信頼度: 97%**

## 6. 補足事項

チャッター機能はLivewireコンポーネントとして実装されており、リアクティブなUI更新を実現している。各種アクションはFilamentのAction機能を活用し、モーダルダイアログによる入力を提供。フィルタリング・ソート機能は豊富なオプションを備えている。
