---
generated_at: 2025-12-26 23:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-活動タイプ管理（採用）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全項目で根拠あり、特別なレビュー優先項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/recruitments/src/Models/ActivityType.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/ActivityTypeResource.php`
- E-03: `plugins/webkul/support/src/Models/ActivityType.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 採用モジュールのActivityTypeはサポートモジュールを継承 | E-01 | ○ |
| C-02 | activity_typesテーブルを使用 | E-03 | ○ |
| C-03 | ベースモデルに多数のフィールド存在（name, icon, delay_*等） | E-03 | ○ |
| C-04 | SortableTraitを使用 | E-03 | ○ |
| C-05 | SoftDeletesトレイトを使用 | E-03 | ○ |
| C-06 | activityPlan関連（BelongsTo） | E-03 | ○ |
| C-07 | triggeredNextType関連（自己参照BelongsTo） | E-03 | ○ |
| C-08 | activityTypes関連（自己参照HasMany） | E-03 | ○ |
| C-09 | suggestedActivityTypes関連（多対多） | E-03 | ○ |
| C-10 | defaultUser関連（BelongsTo） | E-03 | ○ |
| C-11 | is_active, keep_doneのboolean cast | E-03 | ○ |
| C-12 | BaseActivityTypeResourceを継承 | E-02 | ○ |
| C-13 | Configurationsクラスター配下 | E-02 | ○ |
| C-14 | pluginName = 'recruitments' | E-02 | ○ |
| C-15 | shouldRegisterNavigation = true | E-02 | ○ |
| C-16 | ListActivityTypes, CreateActivityType, EditActivityType, ViewActivityTypeページ構成 | E-02 | ○ |
| C-17 | ナビゲーショングループ設定のオーバーライド | E-02 | ○ |
| C-18 | 機能一覧でF090として定義 | E-04 | ○ |
| C-19 | recruitments::filament/clusters/configurationsの翻訳使用 | E-02 | ○ |
| C-20 | delay_count, delay_unit, delay_fromによる遅延設定 | E-03 | ○ |
| C-21 | chaining_typeによるチェーン設定 | E-03 | ○ |
| C-22 | pluginフィールドでプラグイン識別 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目で根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] サポートモジュールとのデータ共有確認
- [ ] チェーン機能の動作確認
- [ ] 遅延計算ロジックの確認
- [ ] 活動プランとの連携確認
