---
generated_at: 2025-12-26 23:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：91-活動プラン管理（採用）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **エラーコード体系**：コード内に明示的定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/ActivityPlanResource.php`
- E-02: `plugins/webkul/recruitments/src/Models/ActivityPlan.php`
- E-03: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/ActivityPlanResource.php`
- E-04: `plugins/webkul/recruitments/src/Policies/ActivityPlanPolicy.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ActivityPlanResourceはBaseActivityPlanResourceを継承 | E-01 L34 | ○ |
| C-02 | モデルはActivityPlan::class | E-01 L36 | ○ |
| C-03 | クラスターはConfigurations | E-01 L38 | ○ |
| C-04 | テーブルカラム: name, department, manager, company, is_active | E-01 L51-80 | ○ |
| C-05 | フィルター: is_active, QueryBuilder | E-01 L82-134 | ○ |
| C-06 | アクション: View, Edit, Restore, Delete, ForceDelete | E-01 L154-179 | ○ |
| C-07 | 一括アクション: Restore, Delete, ForceDelete | E-01 L182-204 | ○ |
| C-08 | plugin='recruitments'でフィルタリング | E-01 L227-229 | ○ |
| C-09 | 新規作成時にplugin='recruitments'を自動設定 | E-01 L212 | ○ |
| C-10 | creator_idにログインユーザーIDを設定 | E-01 L214 | ○ |
| C-11 | company_idにデフォルト会社を設定 | E-01 L216 | ○ |
| C-12 | ページ: index, edit, view | E-01 L233-238 | ○ |
| C-13 | モデルはBaseActivityPlanを継承 | E-02 L5-10 | ○ |
| C-14 | フォームにname, department_id, company_id, is_activeフィールド | E-03 L65-91 | ○ |
| C-15 | 機能IDはF091 | E-05 L92 | ○ |
| C-16 | ActivityPlanPolicyによる権限制御 | E-04（ファイル存在） | ○ |
| C-17 | パフォーマンス要件: 一覧1秒、作成2秒 | **根拠なし** | △ |
| C-18 | エラーコード体系 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は設計書として推測で記載
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- エラーコード体系はコード内に明示的定義なし
  - 候補：エラーハンドリング仕様書 / 例外定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は十分なコード根拠あり
- 1: 中リスク - パフォーマンス・エラー処理は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] ActivityPlanResourceの継承関係が正しいか確認
- [ ] plugin='recruitments'のフィルタリングが意図通りか確認
- [ ] パフォーマンス要件の妥当性を確認
- [ ] エラーハンドリングの実装状況を確認
