---
generated_at: 2025-12-26 23:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：92-部門管理（採用）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **エラーコード体系**：コード内に明示的定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/DepartmentResource.php`
- E-02: `plugins/webkul/recruitments/src/Models/Department.php`
- E-03: `plugins/webkul/employees/src/Filament/Resources/DepartmentResource.php`
- E-04: `plugins/webkul/recruitments/src/Policies/DepartmentPolicy.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DepartmentResourceはBaseDepartmentResourceを継承 | E-01 L18 | ○ |
| C-02 | モデルはDepartment::class | E-01 L20 | ○ |
| C-03 | クラスターはConfigurations | E-01 L22 | ○ |
| C-04 | ナビゲーションアイコンはbuilding-office-2 | E-01 L24 | ○ |
| C-05 | サブナビゲーション位置はStart | E-01 L26 | ○ |
| C-06 | テーブルはカードグリッド形式(md:2, xl:3) | E-01 L41-44 | ○ |
| C-07 | ページ: index, create, edit, view, employees | E-01 L56-64 | ○ |
| C-08 | サブナビゲーション: View, Edit, ManageEmployee | E-01 L47-53 | ○ |
| C-09 | モデルはBaseDepartmentを継承 | E-02 L5-10 | ○ |
| C-10 | フォームにname, parent_id, manager_id, company_id, colorフィールド | E-03 L96-142 | ○ |
| C-11 | 階層構造ツリー表示機能あり | E-03 L344-438 | ○ |
| C-12 | 機能IDはF092 | E-05 L93 | ○ |
| C-13 | DepartmentPolicyによる権限制御 | E-04（ファイル存在） | ○ |
| C-14 | 削除済みレコードは選択肢に表示（Deleted表示） | E-03 L109-115 | ○ |
| C-15 | パフォーマンス要件: 一覧1秒 | **根拠なし** | △ |
| C-16 | エラーコード体系 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は設計書として推測で記載
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- エラーコード体系はコード内に明示的定義なし
  - 候補：エラーハンドリング仕様書 / 例外定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は十分なコード根拠あり
- 1: 中リスク - パフォーマンス・エラー処理は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] DepartmentResourceの継承関係が正しいか確認
- [ ] カードグリッド形式の表示が意図通りか確認
- [ ] 階層ツリー表示の動作を確認
- [ ] サブナビゲーションの動作を確認
