---
generated_at: 2025-12-26 23:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：93-休暇申請管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **重複エラー処理**：コード内に明示的実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/TimeOffResource.php`
- E-02: `plugins/webkul/time-off/src/Models/Leave.php`
- E-03: `plugins/webkul/time-off/src/Enums/State.php`
- E-04: `plugins/webkul/time-off/src/Traits/TimeOffHelper.php`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TimeOffResourceはResourceを継承 | E-01 L32 | ○ |
| C-02 | モデルはLeave::class | E-01 L36 | ○ |
| C-03 | クラスターはManagement | E-01 L40 | ○ |
| C-04 | TimeOffHelperトレイトを使用 | E-01 L34 | ○ |
| C-05 | テーブルカラム: employee, holidayStatus, private_name, date_from, date_to, duration_display, state | E-01 L63-93 | ○ |
| C-06 | グループ: employee, holidayStatus, state, date_from, date_to | E-01 L95-110 | ○ |
| C-07 | アクション: approve, refuse, view, edit, delete | E-01 L112-161 | ○ |
| C-08 | 承認時に状態をVALIDATE_TWOに更新 | E-01 L119-123 | ○ |
| C-09 | 却下時に状態をREFUSEに更新 | E-01 L143 | ○ |
| C-10 | 承認済み時は承認ボタン非表示 | E-01 L117 | ○ |
| C-11 | 却下済み時は却下ボタン非表示 | E-01 L140 | ○ |
| C-12 | ページ: index, create, edit, view | E-01 L237-243 | ○ |
| C-13 | Leaveモデルのテーブルはtime_off_leaves | E-02 L22 | ○ |
| C-14 | HasChatter, HasLogActivityトレイトを使用 | E-02 L20 | ○ |
| C-15 | stateはState Enumでキャスト | E-02 L83 | ○ |
| C-16 | 機能IDはF093 | E-05 L94 | ○ |
| C-17 | 半日休暇の場合は0.5日表示 | E-01 L216-218 | ○ |
| C-18 | support_documentがtrueで添付ファイル表示 | E-01 L229 | ○ |
| C-19 | パフォーマンス要件: 一覧1秒 | **根拠なし** | △ |
| C-20 | 重複申請エラー処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は設計書として推測で記載
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 重複申請チェックの実装はTimeOffHelperトレイト内を要確認
  - 候補：TimeOffHelper.php / バリデーションルール

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は十分なコード根拠あり
- 0: 低リスク - 状態管理のEnum実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] TimeOffHelperトレイトのフォーム実装を確認
- [ ] State Enumの遷移ルールを確認
- [ ] 承認/却下アクションの権限制御を確認
- [ ] 重複申請チェックの実装有無を確認
