---
generated_at: 2025-12-26 23:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：96-自分の休暇割当管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **従業員申請可能タイプ判定**：コード内の詳細実装を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyAllocationResource.php`
- E-02: `plugins/webkul/time-off/src/Models/LeaveAllocation.php`
- E-03: `plugins/webkul/time-off/src/Enums/EmployeeRequest.php`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MyAllocationResourceはResourceを継承 | E-01 L17 | ○ |
| C-02 | モデルはLeaveAllocation::class | E-01 L21 | ○ |
| C-03 | クラスターはMyTime | E-01 L25 | ○ |
| C-04 | AllocationHelperトレイトを使用 | E-01 L19 | ○ |
| C-05 | テーブルカラム: holidayStatus, name, number_of_days, allocation_type, state | E-01 L41-60 | ○ |
| C-06 | ログインユーザーの従業員IDでフィルタリング | E-01 L148-157 | ○ |
| C-07 | ページ: index, create, edit, view | E-01 L160-166 | ○ |
| C-08 | 新規作成時にemployee_id自動設定 | E-01 L143-146 | ○ |
| C-09 | LeaveAllocationモデルのテーブルはtime_off_leave_allocations | E-02 L19 | ○ |
| C-10 | 機能IDはF096 | E-04 L97 | ○ |
| C-11 | 管理者機能（承認/却下）は含まれない | E-01（アクション一覧） | ○ |
| C-12 | employee_requests設定による申請可否制御 | E-03（Enum存在） | ○ |
| C-13 | modifyQueryUsing によるユーザースコープ制限 | E-01 L148-157 | ○ |
| C-14 | パフォーマンス要件: 一覧1秒 | **根拠なし** | △ |
| C-15 | 申請可能タイプ判定の詳細ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は設計書として推測で記載
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 申請可能タイプ判定のロジック（employee_requests使用箇所）
  - 候補：AllocationHelper.php / フォーム定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は十分なコード根拠あり
- 1: 中リスク - 従業員申請可否判定のロジックを要確認

## 6) レビュアーチェックリスト（最小）
- [ ] modifyQueryUsing によるユーザースコープ制御を確認
- [ ] employee_requests による申請可否制御を確認
- [ ] AllocationResourceとの機能差分を確認
- [ ] 削除可能状態のロジックを確認
