---
generated_at: 2025-12-26 23:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：97-休暇タイプ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **完全削除制限ロジック**：コード内の実装を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/LeaveTypeResource.php`
- E-02: `plugins/webkul/time-off/src/Models/LeaveType.php`
- E-03: `plugins/webkul/time-off/src/Enums/LeaveValidationType.php`
- E-04: `plugins/webkul/time-off/src/Enums/RequiresAllocation.php`
- E-05: `plugins/webkul/time-off/src/Enums/EmployeeRequest.php`
- E-06: `plugins/webkul/time-off/src/Enums/AllocationValidationType.php`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LeaveTypeResourceはResourceを継承 | E-01 L53 | ○ |
| C-02 | モデルはLeaveType::class | E-01 L55 | ○ |
| C-03 | クラスターはConfigurations | E-01 L59 | ○ |
| C-04 | フォームにname, color, leave_validation_type, requires_allocation等 | E-01 L68-175 | ○ |
| C-05 | テーブルカラム: name, leave_validation_type, notifiedTimeOffOfficers, requires_allocation等 | E-01 L177-223 | ○ |
| C-06 | QueryBuilderによるフィルタ機能 | E-01 L224-272 | ○ |
| C-07 | アクション: View, Edit, Delete, Restore | E-01 L275-292 | ○ |
| C-08 | 一括アクション: Delete, ForceDelete, Restore | E-01 L293-327 | ○ |
| C-09 | ページ: index, create, view, edit | E-01 L436-443 | ○ |
| C-10 | LeaveTypeモデルのテーブルはtime_off_leave_types | E-02 L18 | ○ |
| C-11 | SoftDeletesトレイトを使用 | E-02 L16 | ○ |
| C-12 | SortableTrait（並び替え）を使用 | E-02 L16 | ○ |
| C-13 | leave_validation_typeはLeaveValidationType Enumでキャスト | E-02 L43 | ○ |
| C-14 | notifiedTimeOffOfficersリレーションあり | E-02 L56-59 | ○ |
| C-15 | fillable項目: name, color, leave_validation_type, requires_allocation等 | E-02 L20-40 | ○ |
| C-16 | 機能IDはF097 | E-07 L98 | ○ |
| C-17 | RequiresAllocation Enum存在 | E-04（ファイル存在） | ○ |
| C-18 | EmployeeRequest Enum存在 | E-05（ファイル存在） | ○ |
| C-19 | employee_requestsはrequires_allocation=YESの場合のみ表示 | E-01 L100-106 | ○ |
| C-20 | allows_negativeとmax_allowed_negativeフィールドあり | E-01 L155-167 | ○ |
| C-21 | パフォーマンス要件: 一覧1秒 | **根拠なし** | △ |
| C-22 | 完全削除制限ロジック詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は設計書として推測で記載
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 完全削除制限ロジック（関連データチェック）の実装
  - 候補：ForceDeleteBulkAction内の処理 / QueryExceptionハンドリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は十分なコード根拠あり
- 0: 低リスク - Enum定義による設定値の網羅性確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各Enumの値定義を確認
- [ ] requires_allocationによる条件分岐を確認
- [ ] notifiedTimeOffOfficersの多対多リレーションを確認
- [ ] SortableTraitの動作を確認
