---
generated_at: 2025-12-26 23:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：98-休暇発生プラン管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **発生計算ロジック**：詳細実装を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource.php`
- E-02: `plugins/webkul/time-off/src/Models/LeaveAccrualPlan.php`
- E-03: `plugins/webkul/time-off/src/Enums/AccruedGainTime.php`
- E-04: `plugins/webkul/time-off/src/Enums/CarryoverDate.php`
- E-05: `plugins/webkul/time-off/src/Enums/CarryoverMonth.php`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AccrualPlanResourceはResourceを継承 | E-01 L42 | ○ |
| C-02 | モデルはLeaveAccrualPlan::class | E-01 L44 | ○ |
| C-03 | クラスターはConfigurations | E-01 L48 | ○ |
| C-04 | フォームにname, is_based_on_worked_time, accrued_gain_time, carryover_date等 | E-01 L62-131 | ○ |
| C-05 | テーブルカラム: name, leaveAccrualLevels(count) | E-01 L135-144 | ○ |
| C-06 | アクション: View, Edit, Delete | E-01 L146-165 | ○ |
| C-07 | サブナビゲーション: ViewAccrualPlan, EditAccrualPlan, ManageMilestone | E-01 L210-216 | ○ |
| C-08 | ページ: index, create, view, edit, milestones | E-01 L229-237 | ○ |
| C-09 | LeaveAccrualPlanモデルのテーブルはtime_off_leave_accrual_plans | E-02 L18 | ○ |
| C-10 | fillable項目: name, is_based_on_worked_time, accrued_gain_time, carryover_date等 | E-02 L20-33 | ○ |
| C-11 | leaveAccrualLevelsリレーションあり | E-02 L57-60 | ○ |
| C-12 | carryover_dateがOTHERの場合、日月を指定 | E-01 L91-125 | ○ |
| C-13 | 月ごとの日数を動的に計算（Carbonを使用） | E-01 L99-113 | ○ |
| C-14 | 機能IDはF098 | E-06 L99 | ○ |
| C-15 | MilestoneRelationManagerでレベル管理 | E-01 L219-225 | ○ |
| C-16 | accrued_gain_time, carryover_date, carryover_month Enum存在 | E-03, E-04, E-05（ファイル存在） | ○ |
| C-17 | パフォーマンス要件: 一覧1秒 | **根拠なし** | △ |
| C-18 | 発生計算の詳細ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値は設計書として推測で記載
  - 候補：負荷テスト結果 / 非機能要件定義書 / SLA定義書
- 発生計算の詳細ロジック（バッチ処理、スケジューラ）
  - 候補：Commandクラス / Schedulerクラス / サービスクラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能仕様は十分なコード根拠あり
- 1: 中リスク - 発生計算の実行タイミング・ロジックを要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 各Enumの値定義を確認
- [ ] leaveAccrualLevelsリレーションの構造を確認
- [ ] 繰越日設定の動的日数計算を確認
- [ ] マイルストーン管理画面の動作を確認
