---
generated_at: 2025-12-26 14:15:00
metrics:
  claims_total: 369
  claims_with_evidence: 369
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：369 / 369、根拠なし：0
- 優先レビュー（高）
  1. 全画面がFilament PHPのResourceクラスとPagesディレクトリから特定されており、根拠は明確です
  2. 画面遷移図はFilamentの標準的なCRUDパターンに基づいて作成されています
  3. カテゴリ分類はプラグインディレクトリ構造に基づいています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/` - 会計モジュールのFilamentリソース
- E-02: `plugins/webkul/blogs/src/Filament/Admin/Resources/` - ブログモジュールの管理者リソース
- E-03: `plugins/webkul/blogs/src/Filament/Customer/Resources/` - ブログモジュールの顧客リソース
- E-04: `plugins/webkul/contacts/src/Filament/Resources/` - 連絡先モジュールのリソース
- E-05: `plugins/webkul/employees/src/Filament/Resources/` - 従業員モジュールのリソース
- E-06: `plugins/webkul/fields/src/Filament/Resources/` - フィールドモジュールのリソース
- E-07: `plugins/webkul/inventories/src/Filament/Clusters/` - 在庫モジュールのクラスター
- E-08: `plugins/webkul/invoices/src/Filament/Clusters/` - 請求書モジュールのクラスター
- E-09: `plugins/webkul/partners/src/Filament/Resources/` - パートナーモジュールのリソース
- E-10: `plugins/webkul/plugin-manager/src/Filament/Resources/` - プラグイン管理モジュールのリソース
- E-11: `plugins/webkul/products/src/Filament/Resources/` - 商品モジュールのリソース
- E-12: `plugins/webkul/projects/src/Filament/Resources/` - プロジェクトモジュールのリソース
- E-13: `plugins/webkul/purchases/src/Filament/Admin/Clusters/` - 購買モジュールの管理者クラスター
- E-14: `plugins/webkul/recruitments/src/Filament/Clusters/` - 採用モジュールのクラスター
- E-15: `plugins/webkul/sales/src/Filament/Clusters/` - 販売モジュールのクラスター
- E-16: `plugins/webkul/security/src/Filament/Resources/` - セキュリティモジュールのリソース
- E-17: `plugins/webkul/support/src/Filament/Resources/` - サポートモジュールのリソース
- E-18: `plugins/webkul/time-off/src/Filament/Clusters/` - 休暇モジュールのクラスター
- E-19: `plugins/webkul/timesheets/src/Filament/Resources/` - タイムシートモジュールのリソース
- E-20: `plugins/webkul/website/src/Filament/Admin/Resources/` - ウェブサイトモジュールの管理者リソース
- E-21: `plugins/webkul/website/src/Filament/Customer/Resources/` - ウェブサイトモジュールの顧客リソース
- E-22: `resources/views/welcome.blade.php` - ウェルカムページのBladeテンプレート

## 3) Claims と根拠の対応（レビューの主戦場）

### 会計モジュール（Accounts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 勘定科目一覧画面が存在する | E-01: AccountResource/Pages/ListAccounts.php | ○ |
| C-02 | 勘定科目作成画面が存在する | E-01: AccountResource/Pages/CreateAccount.php | ○ |
| C-03 | 勘定科目編集画面が存在する | E-01: AccountResource/Pages/EditAccount.php | ○ |
| C-04 | 勘定科目詳細画面が存在する | E-01: AccountResource/Pages/ViewAccount.php | ○ |
| C-05 | 請求書CRUD画面が存在する | E-01: InvoiceResource/Pages/ | ○ |
| C-06 | 仕入請求書CRUD画面が存在する | E-01: BillResource/Pages/ | ○ |
| C-07 | 支払CRUD画面が存在する | E-01: PaymentsResource/Pages/ | ○ |
| C-08 | 税管理画面が存在する | E-01: TaxResource/Pages/ | ○ |

### ブログモジュール（Blogs）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | 投稿CRUD画面（管理者）が存在する | E-02: PostResource/Pages/ | ○ |
| C-10 | タグ管理画面が存在する | E-02: TagResource/Pages/ManageTags.php | ○ |
| C-11 | カテゴリ管理画面が存在する | E-02: CategoryResource/Pages/ManageCategories.php | ○ |
| C-12 | カテゴリ一覧（顧客）が存在する | E-03: CategoryResource/Pages/ListCategories.php | ○ |
| C-13 | 投稿詳細（顧客）が存在する | E-03: PostResource/Pages/ViewPost.php | ○ |

### 連絡先モジュール（Contacts）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | パートナーCRUD画面が存在する | E-04: PartnerResource/Pages/ | ○ |
| C-15 | 住所管理画面が存在する | E-04: PartnerResource/Pages/ManageAddresses.php | ○ |
| C-16 | 連絡先管理画面が存在する | E-04: PartnerResource/Pages/ManageContacts.php | ○ |
| C-17 | 設定管理画面（タグ、敬称、業種、銀行）が存在する | E-04: Clusters/Configurations/Resources/ | ○ |

### 従業員モジュール（Employees）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | 従業員CRUD画面が存在する | E-05: EmployeeResource/Pages/ | ○ |
| C-19 | 部署CRUD画面が存在する | E-05: DepartmentResource/Pages/ | ○ |
| C-20 | スキル・履歴書管理画面が存在する | E-05: EmployeeResource/Pages/ManageSkill.php, ManageResume.php | ○ |
| C-21 | 設定画面（職位、カレンダー等）が存在する | E-05: Clusters/Configurations/Resources/ | ○ |

### 在庫モジュール（Inventories）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | 商品CRUD画面が存在する | E-07: Products/Resources/ProductResource/Pages/ | ○ |
| C-23 | 入庫CRUD画面が存在する | E-07: Operations/Resources/ReceiptResource/Pages/ | ○ |
| C-24 | 出庫CRUD画面が存在する | E-07: Operations/Resources/DeliveryResource/Pages/ | ○ |
| C-25 | 倉庫設定画面が存在する | E-07: Configurations/Resources/WarehouseResource/Pages/ | ○ |
| C-26 | ロケーション設定画面が存在する | E-07: Configurations/Resources/LocationResource/Pages/ | ○ |

### プロジェクトモジュール（Projects）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | プロジェクトCRUD画面が存在する | E-12: ProjectResource/Pages/ | ○ |
| C-28 | タスクCRUD画面が存在する | E-12: TaskResource/Pages/ | ○ |
| C-29 | マイルストーン管理画面が存在する | E-12: ProjectResource/Pages/ManageMilestones.php | ○ |
| C-30 | タイムシート管理画面が存在する | E-12: TaskResource/Pages/ManageTimesheets.php | ○ |

### 購買モジュール（Purchases）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | 見積依頼CRUD画面が存在する | E-13: Orders/Resources/QuotationResource/Pages/ | ○ |
| C-32 | 発注書CRUD画面が存在する | E-13: Orders/Resources/PurchaseOrderResource/Pages/ | ○ |
| C-33 | 仕入先CRUD画面が存在する | E-13: Orders/Resources/VendorResource/Pages/ | ○ |
| C-34 | 購買契約CRUD画面が存在する | E-13: Orders/Resources/PurchaseAgreementResource/Pages/ | ○ |

### 販売モジュール（Sales）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | 見積書CRUD画面が存在する | E-15: Orders/Resources/QuotationResource/Pages/ | ○ |
| C-36 | 受注CRUD画面が存在する | E-15: Orders/Resources/OrderResource/Pages/ | ○ |
| C-37 | 顧客CRUD画面が存在する | E-15: Orders/Resources/CustomerResource/Pages/ | ○ |
| C-38 | 請求対象注文一覧が存在する | E-15: ToInvoice/Resources/OrderToInvoiceResource/Pages/ | ○ |

### セキュリティモジュール（Security）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | ユーザーCRUD画面が存在する | E-16: UserResource/Pages/ | ○ |
| C-40 | ロールCRUD画面が存在する | E-16: RoleResource/Pages/ | ○ |
| C-41 | 会社CRUD画面が存在する | E-16: CompanyResource/Pages/ | ○ |
| C-42 | チーム管理画面が存在する | E-16: TeamResource/Pages/ManageTeams.php | ○ |

### 休暇モジュール（Time Off）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | マイ休暇CRUD画面が存在する | E-18: MyTime/Resources/MyTimeOffResource/Pages/ | ○ |
| C-44 | 休暇管理CRUD画面が存在する | E-18: Management/Resources/TimeOffResource/Pages/ | ○ |
| C-45 | 割当管理CRUD画面が存在する | E-18: Management/Resources/AllocationResource/Pages/ | ○ |
| C-46 | 休暇タイプ設定画面が存在する | E-18: Configurations/Resources/LeaveTypeResource/Pages/ | ○ |

### その他モジュール
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | タイムシート管理画面が存在する | E-19: TimesheetResource/Pages/ManageTimesheets.php | ○ |
| C-48 | ウェブサイトページCRUD画面（管理者）が存在する | E-20: PageResource/Pages/ | ○ |
| C-49 | プラグイン一覧画面が存在する | E-10: PluginResource/Pages/ListPlugins.php | ○ |
| C-50 | ウェルカムページが存在する | E-22: welcome.blade.php | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての画面がFilament PHPのリソースファイルから直接抽出されており、不足情報はありません
- ただし、以下の点は実行時確認が必要です：
  - 実際のナビゲーション構成（メニュー表示順序）
  - 権限による画面アクセス制限
  - 動的に生成される画面（モーダルなど）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての画面がソースコードから特定されています
- 注意点：
  - 一部の画面は継承や拡張により動作が変わる可能性があります
  - Filament v3のPage/Resourceパターンに基づいています
  - カスタムページやモーダルは本一覧に含まれていない場合があります

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧.csvの全行がFilamentリソースファイルと対応しているか確認
- [ ] 画面遷移図のMermaid記法が正しくレンダリングされるか確認
- [ ] カテゴリ分類がプラグイン構造と一致しているか確認
- [ ] 画面名が日本語として適切か確認
- [ ] テンプレートファイルパスが正確か確認
- [ ] 重要な画面の漏れがないか確認（特にSettings Pagesなど）
