# 画面遷移図

本ドキュメントはAureus ERPシステムの画面遷移を表します。

## 1. 全体構成

```mermaid
graph TB
    subgraph "メインナビゲーション"
        Welcome[ウェルカムページ]
        Dashboard[ダッシュボード]
    end

    subgraph "モジュール"
        Accounts[会計]
        Blogs[ブログ]
        Contacts[連絡先]
        Employees[従業員]
        Inventories[在庫]
        Invoices[請求書]
        Partners[パートナー]
        Products[商品]
        Projects[プロジェクト]
        Purchases[購買]
        Recruitments[採用]
        Sales[販売]
        Security[セキュリティ]
        TimeOff[休暇]
        Timesheets[タイムシート]
        Website[ウェブサイト]
    end

    Welcome --> Dashboard
    Dashboard --> Accounts
    Dashboard --> Blogs
    Dashboard --> Contacts
    Dashboard --> Employees
    Dashboard --> Inventories
    Dashboard --> Invoices
    Dashboard --> Partners
    Dashboard --> Products
    Dashboard --> Projects
    Dashboard --> Purchases
    Dashboard --> Recruitments
    Dashboard --> Sales
    Dashboard --> Security
    Dashboard --> TimeOff
    Dashboard --> Timesheets
    Dashboard --> Website
```

## 2. 会計モジュール（Accounts）

```mermaid
graph LR
    subgraph "会計"
        AccountList[勘定科目一覧]
        AccountCreate[勘定科目作成]
        AccountEdit[勘定科目編集]
        AccountView[勘定科目詳細]

        InvoiceList[請求書一覧]
        InvoiceCreate[請求書作成]
        InvoiceEdit[請求書編集]
        InvoiceView[請求書詳細]

        BillList[仕入請求書一覧]
        BillCreate[仕入請求書作成]
        BillEdit[仕入請求書編集]
        BillView[仕入請求書詳細]

        PaymentList[支払一覧]
        PaymentCreate[支払作成]
        PaymentEdit[支払編集]
        PaymentView[支払詳細]

        JournalList[仕訳帳一覧]
        TaxList[税一覧]
    end

    AccountList --> AccountCreate
    AccountList --> AccountView
    AccountView --> AccountEdit

    InvoiceList --> InvoiceCreate
    InvoiceList --> InvoiceView
    InvoiceView --> InvoiceEdit

    BillList --> BillCreate
    BillList --> BillView
    BillView --> BillEdit

    PaymentList --> PaymentCreate
    PaymentList --> PaymentView
    PaymentView --> PaymentEdit
```

## 3. ブログモジュール（Blogs）

```mermaid
graph LR
    subgraph "管理者"
        PostList[投稿一覧]
        PostCreate[投稿作成]
        PostEdit[投稿編集]
        PostView[投稿詳細]

        TagManage[タグ管理]
        CategoryManage[カテゴリ管理]
    end

    subgraph "顧客"
        CustomerCategoryList[カテゴリ一覧]
        CustomerCategoryView[カテゴリ詳細]
        CustomerPostView[投稿詳細]
    end

    PostList --> PostCreate
    PostList --> PostView
    PostView --> PostEdit

    CustomerCategoryList --> CustomerCategoryView
    CustomerCategoryView --> CustomerPostView
```

## 4. 連絡先モジュール（Contacts）

```mermaid
graph LR
    subgraph "連絡先"
        PartnerList[パートナー一覧]
        PartnerCreate[パートナー作成]
        PartnerEdit[パートナー編集]
        PartnerView[パートナー詳細]
        AddressManage[住所管理]
        ContactManage[連絡先管理]
    end

    subgraph "設定"
        TagManage[タグ管理]
        TitleManage[敬称管理]
        IndustryManage[業種管理]
        BankManage[銀行管理]
        BankAccountManage[銀行口座管理]
    end

    PartnerList --> PartnerCreate
    PartnerList --> PartnerView
    PartnerView --> PartnerEdit
    PartnerView --> AddressManage
    PartnerView --> ContactManage
```

## 5. 従業員モジュール（Employees）

```mermaid
graph LR
    subgraph "従業員管理"
        EmployeeList[従業員一覧]
        EmployeeCreate[従業員作成]
        EmployeeEdit[従業員編集]
        EmployeeView[従業員詳細]
        ResumeManage[履歴書管理]
        SkillManage[スキル管理]

        DepartmentList[部署一覧]
        DepartmentCreate[部署作成]
        DepartmentEdit[部署編集]
        DepartmentView[部署詳細]
    end

    subgraph "設定"
        SkillTypeList[スキルタイプ一覧]
        JobPositionList[職位一覧]
        CalendarList[カレンダー一覧]
    end

    EmployeeList --> EmployeeCreate
    EmployeeList --> EmployeeView
    EmployeeView --> EmployeeEdit
    EmployeeView --> ResumeManage
    EmployeeView --> SkillManage

    DepartmentList --> DepartmentCreate
    DepartmentList --> DepartmentView
    DepartmentView --> DepartmentEdit
```

## 6. 在庫モジュール（Inventories）

```mermaid
graph LR
    subgraph "商品"
        ProductList[商品一覧]
        ProductCreate[商品作成]
        ProductEdit[商品編集]
        ProductView[商品詳細]

        PackageList[パッケージ一覧]
        LotList[ロット一覧]
    end

    subgraph "オペレーション"
        ReceiptList[入庫一覧]
        DeliveryList[出庫一覧]
        InternalList[内部移動一覧]
        ScrapList[廃棄一覧]
        DropshipList[ドロップシップ一覧]
    end

    subgraph "設定"
        WarehouseList[倉庫一覧]
        LocationList[ロケーション一覧]
        RouteList[ルート一覧]
    end

    ProductList --> ProductCreate
    ProductList --> ProductView
    ProductView --> ProductEdit

    ReceiptList --> ReceiptCreate[入庫作成]
    DeliveryList --> DeliveryCreate[出庫作成]
```

## 7. 請求書モジュール（Invoices）

```mermaid
graph LR
    subgraph "顧客"
        CustInvoiceList[請求書一覧]
        CustInvoiceCreate[請求書作成]
        CustInvoiceEdit[請求書編集]
        CustInvoiceView[請求書詳細]
        CreditNotesList[クレジットノート一覧]
        CustPaymentList[支払一覧]
    end

    subgraph "仕入先"
        VendorBillList[請求書一覧]
        VendorPaymentList[支払一覧]
        VendorRefundList[返金一覧]
    end

    subgraph "設定"
        TaxList[税一覧]
        TaxGroupList[税グループ一覧]
        PaymentTermList[支払条件一覧]
    end

    CustInvoiceList --> CustInvoiceCreate
    CustInvoiceList --> CustInvoiceView
    CustInvoiceView --> CustInvoiceEdit
```

## 8. プロジェクトモジュール（Projects）

```mermaid
graph LR
    subgraph "プロジェクト"
        ProjectList[プロジェクト一覧]
        ProjectCreate[プロジェクト作成]
        ProjectEdit[プロジェクト編集]
        ProjectView[プロジェクト詳細]
        MilestoneManage[マイルストーン管理]
        TaskManage[タスク管理]
    end

    subgraph "タスク"
        TaskList[タスク一覧]
        TaskCreate[タスク作成]
        TaskEdit[タスク編集]
        TaskView[タスク詳細]
        SubTaskManage[サブタスク管理]
        TimesheetManage[タイムシート管理]
    end

    subgraph "設定"
        TaskStageManage[タスクステージ管理]
        ProjectStageManage[プロジェクトステージ管理]
        TagManage[タグ管理]
    end

    ProjectList --> ProjectCreate
    ProjectList --> ProjectView
    ProjectView --> ProjectEdit
    ProjectView --> MilestoneManage
    ProjectView --> TaskManage

    TaskList --> TaskCreate
    TaskList --> TaskView
    TaskView --> TaskEdit
    TaskView --> SubTaskManage
    TaskView --> TimesheetManage
```

## 9. 購買モジュール（Purchases）

```mermaid
graph LR
    subgraph "注文"
        QuotationList[見積依頼一覧]
        QuotationCreate[見積依頼作成]
        QuotationEdit[見積依頼編集]
        QuotationView[見積依頼詳細]

        POList[発注書一覧]
        POCreate[発注書作成]
        POEdit[発注書編集]
        POView[発注書詳細]

        AgreementList[購買契約一覧]
    end

    subgraph "仕入先"
        VendorList[仕入先一覧]
        VendorCreate[仕入先作成]
        VendorEdit[仕入先編集]
        VendorView[仕入先詳細]
    end

    subgraph "商品"
        ProductList[商品一覧]
    end

    QuotationList --> QuotationCreate
    QuotationList --> QuotationView
    QuotationView --> QuotationEdit
    QuotationView --> POCreate

    POList --> POCreate
    POList --> POView
    POView --> POEdit

    VendorList --> VendorCreate
    VendorList --> VendorView
    VendorView --> VendorEdit
```

## 10. 販売モジュール（Sales）

```mermaid
graph LR
    subgraph "注文"
        QuotationList[見積書一覧]
        QuotationCreate[見積書作成]
        QuotationEdit[見積書編集]
        QuotationView[見積書詳細]

        OrderList[受注一覧]
        OrderCreate[受注作成]
        OrderEdit[受注編集]
        OrderView[受注詳細]
        InvoiceManage[請求書管理]
        DeliveryManage[出荷管理]
    end

    subgraph "顧客"
        CustomerList[顧客一覧]
        CustomerCreate[顧客作成]
        CustomerEdit[顧客編集]
        CustomerView[顧客詳細]
    end

    subgraph "請求"
        ToInvoiceList[請求対象注文一覧]
        ToUpsellList[アップセル対象一覧]
    end

    QuotationList --> QuotationCreate
    QuotationList --> QuotationView
    QuotationView --> QuotationEdit
    QuotationView --> OrderCreate

    OrderList --> OrderCreate
    OrderList --> OrderView
    OrderView --> OrderEdit
    OrderView --> InvoiceManage
    OrderView --> DeliveryManage

    CustomerList --> CustomerCreate
    CustomerList --> CustomerView
    CustomerView --> CustomerEdit
```

## 11. セキュリティモジュール（Security）

```mermaid
graph LR
    subgraph "ユーザー管理"
        UserList[ユーザー一覧]
        UserCreate[ユーザー作成]
        UserEdit[ユーザー編集]
        UserView[ユーザー詳細]
    end

    subgraph "ロール管理"
        RoleList[ロール一覧]
        RoleCreate[ロール作成]
        RoleEdit[ロール編集]
        RoleView[ロール詳細]
    end

    subgraph "会社管理"
        CompanyList[会社一覧]
        CompanyCreate[会社作成]
        CompanyEdit[会社編集]
        CompanyView[会社詳細]
    end

    subgraph "チーム管理"
        TeamManage[チーム管理]
    end

    UserList --> UserCreate
    UserList --> UserView
    UserView --> UserEdit

    RoleList --> RoleCreate
    RoleList --> RoleView
    RoleView --> RoleEdit

    CompanyList --> CompanyCreate
    CompanyList --> CompanyView
    CompanyView --> CompanyEdit
```

## 12. 休暇モジュール（Time Off）

```mermaid
graph LR
    subgraph "マイ休暇"
        MyTimeOffList[マイ休暇一覧]
        MyTimeOffCreate[マイ休暇作成]
        MyTimeOffEdit[マイ休暇編集]
        MyTimeOffView[マイ休暇詳細]

        MyAllocationList[マイ割当一覧]
        MyAllocationCreate[マイ割当作成]
    end

    subgraph "管理"
        TimeOffList[休暇管理一覧]
        TimeOffCreate[休暇作成]
        TimeOffEdit[休暇編集]
        TimeOffView[休暇詳細]

        AllocationList[割当一覧]
        AllocationCreate[割当作成]
    end

    subgraph "レポート"
        ByEmployeeList[従業員別レポート]
    end

    subgraph "設定"
        LeaveTypeList[休暇タイプ一覧]
        AccrualPlanList[累積プラン一覧]
        PublicHolidayList[祝日一覧]
    end

    MyTimeOffList --> MyTimeOffCreate
    MyTimeOffList --> MyTimeOffView
    MyTimeOffView --> MyTimeOffEdit

    TimeOffList --> TimeOffCreate
    TimeOffList --> TimeOffView
    TimeOffView --> TimeOffEdit
```

## 13. 採用モジュール（Recruitments）

```mermaid
graph LR
    subgraph "応募"
        ApplicantList[応募者一覧]
        ApplicantEdit[応募者編集]
        ApplicantView[応募者詳細]

        CandidateList[候補者一覧]
        CandidateCreate[候補者作成]
        CandidateEdit[候補者編集]
        CandidateView[候補者詳細]

        JobByPositionList[職位別求人一覧]
    end

    subgraph "設定"
        StageList[ステージ一覧]
        JobPositionList[職位一覧]
        DepartmentList[部署一覧]
        DegreeList[学位一覧]
    end

    ApplicantList --> ApplicantView
    ApplicantView --> ApplicantEdit
    ApplicantView --> CandidateCreate

    CandidateList --> CandidateCreate
    CandidateList --> CandidateView
    CandidateView --> CandidateEdit
```

## 14. 共通画面遷移パターン

### CRUD画面遷移

```mermaid
graph LR
    List[一覧画面] --> Create[作成画面]
    List --> View[詳細画面]
    View --> Edit[編集画面]
    Edit --> View
    Create --> List
```

### リソース関連画面遷移

```mermaid
graph LR
    List[一覧画面] --> View[詳細画面]
    View --> Manage1[関連管理画面1]
    View --> Manage2[関連管理画面2]
    View --> Manage3[関連管理画面3]
```

## 補足事項

- 本システムはFilament PHPをベースとしたERPシステムです
- 各モジュールは独立したプラグインとして構成されています
- 画面遷移はFilament Resourceの標準的なCRUDパターンに基づいています
- 各リソースにはList（一覧）、Create（作成）、Edit（編集）、View（詳細）の標準ページがあります
- 一部のリソースには追加の管理ページ（Manage*）があります
