# 画面機能マッピング 信頼度レポート

## 概要

このレポートは、AureusERP プロジェクトのソースコード分析に基づいて生成された「画面機能マッピング.csv」の信頼度と根拠を示すものです。

## 分析対象

- **プロジェクト名**: AureusERP
- **フレームワーク**: Laravel / Filament PHP
- **分析日時**: 2025年12月26日
- **分析対象ファイル数**: 157 Resource ファイル

## 分析手法

### 1. ソースコード静的解析

Filament PHP フレームワークの規約に基づき、以下のファイル/パターンを分析しました:

- `*Resource.php` - Filament Resource クラス
- `Pages/*.php` - Resource に関連する Page クラス
- クラスター定義ファイル（`Clusters/*.php`）

### 2. 画面特定の根拠

| 分析項目 | 根拠 |
|---------|------|
| Resource クラス | `extends Resource` を継承するクラスを画面単位として識別 |
| モジュール | `plugins/webkul/{module}/` のディレクトリ構造から抽出 |
| クラスター | `protected static ?string $cluster` 属性から抽出 |

### 3. 機能特定の根拠

| 機能種別 | 検出方法 |
|---------|---------|
| List | `getPages()` メソッド内の 'index' ルート定義 |
| Create | `getPages()` メソッド内の 'create' ルート定義 |
| Edit | `getPages()` メソッド内の 'edit' ルート定義 |
| View | `getPages()` メソッド内の 'view' ルート定義 |
| Delete | `DeleteAction::make()` の使用 |
| BulkDelete | `DeleteBulkAction::make()` の使用 |
| Restore | `RestoreAction::make()` の使用 |
| ForceDelete | `ForceDeleteAction::make()` の使用 |
| 関連管理 | `getRecordSubNavigation()` で定義された Manage* ページ |

## 信頼度評価

### 全体信頼度: 85%

#### モジュール別信頼度

| モジュール | 信頼度 | 備考 |
|-----------|--------|------|
| sales | 90% | QuotationResource, OrderResource を詳細分析 |
| purchases | 85% | 基本的なCRUD操作を確認 |
| inventories | 85% | OperationResource の共有パターンを確認 |
| accounts | 80% | 多数のResource間で類似パターンを適用 |
| projects | 90% | ProjectResource, TaskResource を詳細分析 |
| employees | 85% | 基本的なCRUD操作を確認 |
| recruitments | 80% | 標準的なFilamentパターンを適用 |
| time-off | 80% | 標準的なFilamentパターンを適用 |
| security | 90% | UserResource を詳細分析 |
| products | 90% | ProductResource を詳細分析 |
| contacts | 80% | 標準的なFilamentパターンを適用 |
| blogs | 85% | Admin/Customer の2つのパネルを確認 |
| website | 75% | 部分的な分析 |
| timesheets | 85% | ManageTimesheets を確認 |
| plugin-manager | 80% | 基本機能を確認 |
| fields | 80% | カスタムフィールド機能を確認 |
| invoices | 85% | Customer/Vendors/Configuration の3クラスターを確認 |
| partners | 80% | 標準的なFilamentパターンを適用 |
| support | 75% | 部分的な分析 |

## 検証済みパターン

### 詳細分析した主要 Resource

1. **QuotationResource** (sales)
   - Pages: List, Create, View, Edit, ManageInvoices, ManageDeliveries
   - Actions: View, Edit, Delete, ForceDelete, Restore
   - BulkActions: Delete, ForceDelete, Restore
   - Form: 複雑なフォーム構造（Tabs, Repeater, Livewire コンポーネント）

2. **OrderResource** (sales)
   - QuotationResource を継承/参照するパターンを確認

3. **ProductResource** (products)
   - Pages: List, Create, Edit, View, ManageVariants, ManageAttributes
   - Actions: View, Edit, Delete, ForceDelete, Restore, Favorite
   - BulkActions: Print, Delete, ForceDelete, Restore

4. **UserResource** (security)
   - Pages: List, Create, Edit, View
   - Actions: View, Edit, Delete, Restore
   - BulkActions: Delete, ForceDelete, Restore

5. **ProjectResource** (projects)
   - Pages: List, Create, Edit, View, ManageTasks, ManageMilestones
   - Actions: Favorite, Tasks, Milestones, Edit, Delete, ForceDelete, Restore

6. **ReceiptResource** (inventories)
   - OperationResource を参照するパターンを確認

## 制限事項

1. **動的機能**: ランタイムで動的に追加される機能は検出できない場合があります

2. **設定依存機能**: `Settings` クラスの値によって表示/非表示が切り替わる機能があります
   - 例: `allow_timesheets`, `allow_milestones`, `enable_uom`

3. **権限制御**: Policy クラスによる権限制御は本分析に含まれていません

4. **翻訳キー**: 画面名/機能名は翻訳キーから推定しており、実際の表示テキストと異なる場合があります

5. **カスタムアクション**: 各Resourceで定義されたカスタムアクション（例: `Print`, `Favorite`）は一部のみ抽出

## 推奨事項

1. **手動検証**: 重要な画面については実際のアプリケーションで動作確認を推奨

2. **Policy 分析**: 権限制御を含めた完全なマッピングには Policy クラスの分析が必要

3. **翻訳ファイル確認**: 正確な画面名/機能名が必要な場合は `resources/lang/` の翻訳ファイルを参照

4. **定期更新**: コードベースの変更に応じて定期的にマッピングを更新することを推奨

## 分析に使用したファイル

### 詳細分析したファイル

```
/plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php
/plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource.php
/plugins/webkul/products/src/Filament/Resources/ProductResource.php
/plugins/webkul/security/src/Filament/Resources/UserResource.php
/plugins/webkul/projects/src/Filament/Resources/ProjectResource.php
/plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/ReceiptResource.php
```

### 構造分析したファイル

- 全157個の `*Resource.php` ファイル
- 27個の Cluster 定義ファイル

## まとめ

本分析は Filament PHP フレームワークの規約とソースコードの静的解析に基づいています。主要なResourceについては高い信頼度（85-90%）で画面機能マッピングを抽出できていますが、動的機能や設定依存機能については実際のアプリケーションでの検証を推奨します。

---

**生成日時**: 2025年12月26日
**生成ツール**: Claude Code による静的コード分析
