# 画面設計書 1-勘定科目一覧

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける勘定科目一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、企業の会計処理における勘定科目を一覧形式で管理するための画面です。勘定科目の検索、表示、新規作成、編集、削除といった基本的なCRUD操作を提供します。

**業務上の目的・背景**：企業会計において、勘定科目は取引を分類・記録するための基本単位です。適切な勘定科目の設定と管理は、正確な財務諸表作成の基盤となります。本画面により、経理担当者は勘定科目の一元管理が可能となり、会計処理の効率化と正確性の向上を実現します。

**画面へのアクセス方法**：ダッシュボードから「会計」モジュールを選択し、設定メニューから「勘定科目」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 勘定科目一覧の表示（コード、名称、科目タイプ、通貨等）
2. 検索機能による勘定科目の絞り込み
3. 「新規作成」ボタンから勘定科目作成画面への遷移
4. 一覧行クリックによる詳細画面への遷移
5. 行アクションからの編集・削除操作
6. 一括削除操作

**画面遷移**：
- 本画面から遷移可能：勘定科目作成画面、勘定科目詳細画面、勘定科目編集画面
- 本画面への遷移元：会計モジュールメニュー、ダッシュボード

**権限による表示制御**：会計モジュールへのアクセス権限を持つユーザーのみ表示可能です。削除操作は削除権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-018 | 勘定科目一覧 | 主機能 | 勘定科目データの一覧表示と検索 |
| FN-ACC-019 | 勘定科目作成 | 遷移先機能 | 新規勘定科目の作成 |
| FN-ACC-020 | 勘定科目編集 | 遷移先機能 | 既存勘定科目の編集 |

## 画面種別

一覧

## URL/ルーティング

`/accounts/accounts`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- テーブルエリア：勘定科目一覧テーブル
- 行アクション：表示、編集、削除
- 一括操作エリア：一括削除

## 入出力項目

該当なし（一覧画面のため入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | コード | code | string | 勘定科目コード | 検索可能 |
| 2 | 勘定科目名 | name | string | 勘定科目の名称 | 検索可能 |
| 3 | 科目タイプ | account_type | enum | 勘定科目の種類 | 検索可能 |
| 4 | 通貨 | currency.name | string | 関連通貨名 | 検索可能 |
| 5 | 非推奨 | deprecated | boolean | 非推奨フラグ | アイコン表示 |
| 6 | 消込対象 | reconcile | boolean | 消込可能フラグ | アイコン表示 |
| 7 | 非取引 | non_trade | boolean | 非取引フラグ | アイコン表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「+」アイコン付きボタンを押下すると、勘定科目作成画面（CreateAccount）へ遷移します。

### 2-行クリック（表示）

一覧の行をクリックまたは表示アクションを選択すると、該当レコードの詳細画面（ViewAccount）へ遷移します。

### 3-編集アクション

行の編集アクションを選択すると、該当レコードの編集画面（EditAccount）へ遷移します。

### 4-削除アクション

行の削除アクションを選択すると、確認ダイアログ表示後、該当レコードを削除します。成功時は通知メッセージが表示されます。

### 5-一括削除

複数行を選択し一括削除を実行すると、選択されたすべてのレコードが削除されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | accounts_accounts | DELETE | 選択した勘定科目レコードを削除 |
| 一括削除 | accounts_accounts | DELETE | 選択した複数の勘定科目レコードを削除 |

### テーブル別更新項目詳細

#### accounts_accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | 主キー（id）で特定 | 関連テーブルのデータも削除対象となる可能性あり |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 勘定科目が削除されました | 削除成功時 |
| MSG-002 | 成功 | 勘定科目が一括削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| データ取得失敗 | エラーページ表示 | システムエラーが発生しました |
| 削除失敗（関連データあり） | エラー通知表示 | この勘定科目は使用中のため削除できません |
| 権限不足 | 操作拒否 | この操作を行う権限がありません |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されています
- テーブル列は動的に表示/非表示の切り替えが可能です
- ナビゲーションへの表示は無効化されています（shouldRegisterNavigation = false）
