# 画面設計書 10-請求書詳細

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける仕入先請求書詳細画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、仕入先請求書の詳細情報を閲覧するための表示画面です。請求書の基本情報、明細行、合計金額、支払状態などを確認でき、各種アクション（確認、支払、キャンセル等）への導線を提供します。

**業務上の目的・背景**：経理担当者や監査担当者が仕入先請求書の内容を確認し、承認プロセスを進めるために使用します。請求書の全詳細を一画面で把握でき、必要なアクションを迅速に実行できます。

**画面へのアクセス方法**：請求書一覧画面で対象行をクリック、または請求書作成・編集画面からの保存成功後にリダイレクトされます。

**主要な操作・処理内容**：
1. 請求書基本情報の表示（仕入先、日付、参照番号、支払条件等）
2. 請求明細行の表示（商品、数量、単価、税、小計）
3. 合計サマリーの表示（税抜合計、税額、税込合計）
4. その他情報の表示（インコタームズ、支払方法、会社、通貨）
5. 利用規約・備考の表示
6. 各種アクション実行（確認、支払、キャンセル等）
7. チャット/コメント機能
8. クレジットノートの作成
9. 削除操作

**画面遷移**：
- 本画面から遷移可能：請求書編集画面、クレジットノート作成画面
- 本画面への遷移元：請求書一覧画面、請求書作成画面、請求書編集画面

**権限による表示制御**：仕入先請求書の閲覧権限を持つユーザーのみアクセス可能です。各アクションは権限とステータスに応じて表示/非表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-008 | 仕入請求書表示 | 主機能 | 仕入請求書詳細の表示 |
| FN-ACC-007 | 仕入請求書編集 | 遷移先機能 | 編集画面への遷移 |

## 画面種別

詳細

## URL/ルーティング

`/accounts/bills/{record}`

## 画面構成

- 支払状態バッジセクション：支払状態を色付きバッジで表示
- 一般情報セクション：請求書番号、仕入先、日付、参照番号、銀行口座、支払条件等
- タブセクション
  - 請求明細タブ：明細行テーブル（列管理機能付き）、合計サマリー
  - その他情報タブ：インコタームズ、支払方法、会社、通貨情報
  - 利用規約タブ：備考・条件のHTML表示
- ヘッダーアクション：チャット、支払、確認、キャンセル、下書きに戻す、確認済み設定、クレジットノート作成、削除

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

### 支払状態バッジ

| No | 項目名 | 物理名 | 表示形式 |
|----|--------|--------|---------|
| 1 | 支払状態 | payment_state | バッジ表示 |

### 一般情報セクション

| No | 項目名 | 物理名 | 型 | 説明 | 表示形式 |
|----|--------|--------|-----|------|---------|
| 1 | 請求書番号 | name | string | 請求書の識別番号 | テキスト（太字、大サイズ） |
| 2 | 仕入先 | partner.name / invoice_partner_display_name | string | 仕入先名 | テキスト（ユーザーアイコン付き） |
| 3 | 請求日 | invoice_date | date | 請求書の日付 | 日付表示（カレンダーアイコン付き） |
| 4 | 請求書参照 | reference | string | 仕入先請求書番号 | テキスト |
| 5 | 会計日 | date | date | 会計上の日付 | 日付表示（カレンダーアイコン付き） |
| 6 | 支払参照 | payment_reference | string | 支払時の参照番号 | テキスト |
| 7 | 支払先銀行 | partnerBank.account_number | string | 送金先銀行口座 | テキスト |
| 8 | 支払期日 | invoice_date_due | date | 支払期限 | 日付表示（時計アイコン付き） |
| 9 | 支払条件 | invoicePaymentTerm.name | string | 支払条件名 | テキスト（カレンダーアイコン付き） |

### 請求明細タブ

| No | 項目名 | 物理名 | 型 | 説明 | 表示形式 |
|----|--------|--------|-----|------|---------|
| 1 | 商品名 | name | string | 商品・サービス名 | テキスト |
| 2 | 数量 | quantity | decimal | 数量 | 数値 |
| 3 | 単位 | uom.name | string | 単位名 | テキスト（UOM有効時） |
| 4 | 単価 | price_unit | decimal | 単価 | 通貨表示 |
| 5 | 割引率 | discount | decimal | 割引率 | パーセント表示 |
| 6 | 税 | taxes | array | 適用税一覧 | バッジ表示（複数） |
| 7 | 小計 | price_subtotal | decimal | 税抜小計 | 通貨表示 |

### 請求サマリー（Livewireコンポーネント）

| No | 項目名 | 説明 |
|----|--------|------|
| 1 | 税抜合計 | 全明細行の税抜小計合計 |
| 2 | 税額合計 | 全明細行の税額合計 |
| 3 | 税込合計 | 税抜合計 + 税額合計 |

### その他情報タブ

| No | 項目名 | 物理名 | 型 | 説明 | 表示形式 |
|----|--------|--------|-----|------|---------|
| 1 | インコタームズ | invoiceIncoterm.name | string | 貿易条件 | テキスト（地球アイコン付き） |
| 2 | インコタームズ場所 | incoterm_location | string | 貿易条件の場所 | テキスト（マップピンアイコン付き） |
| 3 | 支払方法 | paymentMethodLine.name | string | 優先支払方法 | テキスト（クレジットカードアイコン付き） |
| 4 | 自動転記 | auto_post | boolean | 自動転記フラグ | アイコン表示 |
| 5 | 会社 | company.name | string | 所属会社 | テキスト（ビルアイコン付き） |
| 6 | 通貨 | currency.name | string | 使用通貨 | テキスト（矢印アイコン付き） |

### 利用規約タブ

| No | 項目名 | 物理名 | 型 | 表示形式 |
|----|--------|--------|-----|---------|
| 1 | 備考 | narration | text | HTML表示 |

## イベント仕様

### 1-チャットアクション（ChatterAction）

チャット/コメント機能を呼び出し、請求書に関するコミュニケーションを記録・閲覧します。

### 2-支払アクション（PayAction）

請求書に対する支払を登録するダイアログを表示します。

### 3-確認アクション（ConfirmAction）

下書き状態の請求書を確認済み（POSTED）状態に変更します。

### 4-キャンセルアクション（CancelAction）

請求書をキャンセル状態に変更します。

### 5-下書きに戻すアクション（ResetToDraftAction）

キャンセル済みまたは確認済みの請求書を下書き状態に戻します。

### 6-確認済み設定アクション（SetAsCheckedAction）

請求書を確認済みとしてマークします。

### 7-クレジットノート作成（CreditNoteAction）

この請求書に対するクレジットノート（貸方票）を作成します。

### 8-削除アクション

請求書を削除します。確認ダイアログ表示後に実行され、成功時は通知メッセージが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | accounts_moves | SELECT | 請求書レコードを取得 |
| 削除アクション | accounts_moves | DELETE | 請求書レコードを削除 |
| 確認アクション | accounts_moves | UPDATE | state = POSTED |
| キャンセルアクション | accounts_moves | UPDATE | state = CANCEL |

### テーブル別更新項目詳細

#### accounts_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | id = {record} | 関連テーブルもEagerロード |
| DELETE | - | id = {record} | 確認ダイアログ後に実行 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 請求書が削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコード未存在 | 404エラー表示 | 指定されたデータが見つかりません |
| 権限不足 | 操作拒否 | この操作を行う権限がありません |

## 備考

- 本画面はFilament PHPのViewRecordを継承して実装されています
- HasRecordNavigationTabsトレイトでタブナビゲーションを実装
- HasRepeatableEntryColumnManagerトレイトで明細行テーブルの列管理機能を実装
- Infolistを使用して情報を表示しています
- 明細行はRepeatableEntryで表示され、列の表示/非表示をカスタマイズ可能
- UOM（単位）設定が有効な場合のみ、単位列が表示されます
- 税列は複数のバッジとして表示され、各税の名称が表示されます
- InvoiceSummaryはLivewireコンポーネントとして実装され、リアルタイムに合計を計算
- 各アクションは請求書のステータスに応じて表示/非表示が制御されます
- partner_idがnullの場合はinvoice_partner_display_nameが表示されます
- 通貨表示は請求書の通貨設定に基づきます
