# 画面設計書 100-従業員カテゴリ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「従業員カテゴリ一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は従業員のカテゴリ（タグ）を一覧表示し、管理するための画面である。

**業務上の目的・背景**：従業員を分類・グループ化するためのカテゴリ（タグ）を管理する画面である。カテゴリには名称と識別用の色を設定でき、従業員の属性やスキル、プロジェクト割り当てなど、様々な分類目的で活用できる。例えば「リーダー候補」「技術専門家」「新入社員」などのカテゴリを作成し、従業員に割り当てることで、人材の可視化や検索を効率化する。

**画面へのアクセス方法**：メインメニューから「従業員」モジュール → 「設定」クラスター → 「従業員カテゴリ」を選択してアクセスする。

**主要な操作・処理内容**：
1. 従業員カテゴリデータの一覧表示（名称、色、作成者、作成日時など）
2. 従業員カテゴリの検索・フィルタリング（名称、作成者による検索）
3. 従業員カテゴリのグルーピング表示（職位別、色別、作成者別など）
4. 新規カテゴリの作成（ヘッダーアクション・モーダルフォーム）
5. 個別カテゴリの表示・編集・削除（インライン編集）
6. 複数カテゴリの一括削除

**画面遷移**：
- 本画面から遷移可能：なし（モーダル操作のみ）
- 本画面に遷移してくる画面：従業員モジュール設定メニュー

**権限による表示制御**：認証済みユーザーのみアクセス可能。作成時に現在のログインユーザーがcreator_idに自動設定される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-011 | 従業員カテゴリ管理 | 主機能 | 従業員カテゴリの一覧表示、検索、フィルタ、CRUD操作 |

## 画面種別

一覧

## URL/ルーティング

`/employees/configurations/employee-categories`

## 画面構成

- ヘッダー部：画面タイトル、新規作成ボタン
- テーブル部：従業員カテゴリ一覧テーブル（検索、フィルタ、グルーピング、ソート対応）
- フィルタ部：QueryBuilderによる高度なフィルタ（名称、作成者、日付）
- アクション部：行アクション（表示・編集・削除）、一括アクション（削除）
- モーダル部：作成・編集用モーダルフォーム

## 入出力項目

| No | 項目名 | データ型 | 必須 | 最大長 | 説明 | 備考 |
|----|--------|----------|------|--------|------|------|
| 1 | 名称 | テキスト | ○ | - | カテゴリの名称 | 一意制約あり |
| 2 | 色 | カラー | - | - | 識別用の色（HEX形式） | ColorPicker、未設定時はランダム生成 |

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|----------|
| 1 | ID | 数値 | カテゴリの一意識別子 | デフォルト非表示 |
| 2 | 名称 | テキスト | カテゴリの名称 | 常に表示 |
| 3 | 色 | カラー | 識別用の色 | 常に表示 |
| 4 | 作成者 | テキスト | 作成したユーザー名 | デフォルト非表示 |
| 5 | 作成日時 | 日時 | レコード作成日時 | デフォルト非表示 |
| 6 | 更新日時 | 日時 | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「作成」ボタンを押下すると、モーダルフォームが表示される：
1. 名称を入力（必須、一意）
2. 色を選択（オプション、未設定時はランダムHEXカラーを生成）
3. creator_idに現在のログインユーザーIDが自動設定
4. 保存成功時に通知メッセージを表示

### 2-行クリック（表示）

テーブル行の表示アクションをクリックすると、モーダルで詳細情報が表示される。

### 3-編集アクション

テーブル行の編集アクションをクリックすると、モーダルで編集フォームが表示される。色が未設定の場合はランダムHEXカラーが設定される。

### 4-削除アクション

テーブル行の削除アクションをクリックすると、確認後にレコードが削除される。成功時に通知メッセージが表示される。

### 5-一括削除

テーブル上部の一括アクションから複数選択したレコードを一括で削除する。

### 6-グルーピング

テーブルをグループ化して表示できる（職位別、色別、作成者別、作成日別、更新日別）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | employees_categories | SELECT | カテゴリデータの取得 |
| 作成 | employees_categories | INSERT | 新規カテゴリデータの登録 |
| 編集 | employees_categories | UPDATE | カテゴリデータの更新 |
| 削除 | employees_categories | DELETE | カテゴリデータの削除（物理削除） |

### テーブル別更新項目詳細

#### employees_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須、一意 |
| INSERT | color | フォーム入力値またはランダムHEX | |
| INSERT | creator_id | 現在のログインユーザーID | Hiddenフィールド |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |
| UPDATE | name | フォーム入力値 | |
| UPDATE | color | フォーム入力値またはランダムHEX | 未設定時のみランダム生成 |
| UPDATE | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 従業員カテゴリを作成しました | 作成成功時 |
| MSG-002 | 成功 | 従業員カテゴリを更新しました | 編集成功時 |
| MSG-003 | 成功 | 従業員カテゴリを削除しました | 削除成功時 |
| MSG-004 | 成功 | 従業員カテゴリを一括削除しました | 一括削除成功時 |
| MSG-005 | エラー | この名称は既に使用されています | 一意制約違反時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| データなし | 空状態表示と新規作成ボタンを表示 |
| 一意制約違反 | エラーメッセージを表示 |
| 削除失敗 | エラー通知を表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのListRecordsページとして実装されている
- 作成・編集・表示はモーダルで行われる（Simple Resource）
- EmployeeCategoryResourceにはgetPagesでindexのみが定義されている
- SoftDeletesは使用されていない（物理削除）
- 色フィールドはColorPickerコンポーネントでHEX形式の色を選択
- 色が未設定の場合、fake()->hexColor()でランダムな色が自動生成される
- 名称には一意制約が設定されている（unique(ignoreRecord: true)）
- テーブルの色列はColorColumnで表示される
- グルーピング機能により、様々な切り口でデータを整理可能
